/*!\file:  adjointbalancedthickness_core.cpp
 * \brief compute inverse method adjoint state
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../include/include.h"
#include "../solvers/solvers.h"

void adjointbalancedthickness_core(FemModel* femmodel){
	
	/*parameters: */
	bool control_analysis;
	int  verbose = 0;
	int  solution_type;

	/*retrieve parameters:*/
	femmodel->parameters->FindParam(&verbose,VerboseEnum);
	femmodel->parameters->FindParam(&control_analysis,ControlAnalysisEnum);
	femmodel->parameters->FindParam(&solution_type,SolutionTypeEnum);

	/*compute thickness */
	_printf_("%s\n","      computing thickness");
	femmodel->SetCurrentConfiguration(BalancedthicknessAnalysisEnum);
	solver_linear(femmodel);

	/*Call SurfaceAreax, because some it might be needed by PVector*/
	SurfaceAreax(NULL,femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters);

	/*compute adjoint*/
	_printf_("%s\n","      computing adjoint");
	femmodel->SetCurrentConfiguration(BalancedthicknessAnalysisEnum,AdjointBalancedthicknessAnalysisEnum);
	solver_adjoint_linear(femmodel);
	
	/*Save results*/
	if(solution_type==AdjointSolutionEnum && !control_analysis){
		if(verbose)_printf_("saving results:\n");
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,AdjointEnum);
	}
}
