function md=structtomodel(md,structmd)
%STRUCTTOMODEL - convert a structure into a model
%
%   This function will take all the fields in structmd and copy them to corresponding
%   fields in the md @model class instance. If the field does not exist in md, it is dropped.
%
%   Usage:
%      md=structtomodel(md,structmd)

structfields=fields(structmd);
for i=1:length(structfields),
	field=structfields(i);field=field{1};
	fieldval=getfield(structmd,field);
	if isfield(struct(md),field),
		md=setfield(md,field,fieldval);
	end
end

%some special treatment for models of previous ISSM versions
if isfield(structmd,'drag'), md.drag_coefficient=structmd.drag; end
if isfield(structmd,'p'), md.drag_p=structmd.p; end
if isfield(structmd,'q'), md.drag_q=structmd.p; end
if isfield(structmd,'B'), md.rheology_B=structmd.B; end
if isfield(structmd,'n'), md.rheology_n=structmd.n; end
if (isfield(structmd,'type') & ischar(structmd.type)), 
	if strcmpi(structmd.type,'2d'), md.dim=2; end
	if strcmpi(structmd.type,'3d'), md.dim=3; end
end
