%This test is a test from the ISMP-HOM Intercomparison project
%TestE 
%Four tests to run: - Pattyn frozen
%                   - Stokes frozen
%                   - Pattyn with some sliding
%                   - Stokes with some sliding
printingflag=false;
results={};

for i=1:4,
	Lx=10; %in m
	Ly=5000; %in m
	nx=3; %number of nodes in x direction
	ny=51;
	md=model;
	md=squaremesh(md,Lx,Ly,nx,ny);
	md=geography(md,'',''); %ice sheet test
	md=parameterize(md,'../Par/ISMIPE.par');
	md=extrude(md,10,1);

	if i==1 | i==3,
		md=setelementstype(md,'pattyn','all');
	elseif i==2 | i==4,
		md=setelementstype(md,'stokes','all');
	end

	%Create MPCs to have periodic boundary conditions
	posx=find(md.x==0);
	posx2=find(md.x==max(md.x));
	md.penalties=[posx,posx2];

	%Create spcs on the bed 
	pos=find(md.gridonbed);
	md.spcvelocity=zeros(md.numberofgrids,6);
	md.spcvelocity(pos,1:3)=1;

	%Remove the spc where there is some sliding (case 3 and 4):
	if i==3 | i==4,
		pos=find(md.y/max(md.y)>=0.44 & md.y/max(md.y)<=0.5);
		md.spcvelocity(pos,1:3)=0;
	end

	%Compute the diagnostic
	md=solve(md,'analysis_type',DiagnosticSolutionEnum);

	vx=PatchToVec(md.results.DiagnosticSolution.Vx);
	vy=PatchToVec(md.results.DiagnosticSolution.Vy);
	vz=PatchToVec(md.results.DiagnosticSolution.Vz);
	results{i}=md.results.DiagnosticSolution;

	if i==1,
		plotmodel(md,'data',vy,'ylim',[-10 80],'layer',md.numlayers,'sectionvalue','../Exp/ISMIPE.exp','resolution',[10 10],'title','','xlabel','')
		set(gcf,'Color','w')
		printmodel('ismipepattynvxfrozen','png','margin','on','marginsize',25,'frame','off','resolution',1.5,'hardcopy','off');
		system(['mv ismipepattynvxfrozen.png ' ISSM_DIR '/website/doc_pdf/validation/Images/ISMIP/TestE ']);
	elseif i==2,
		plotmodel(md,'data',vy,'ylim',[-10 80],'layer',md.numlayers,'sectionvalue','../Exp/ISMIPE.exp','resolution',[10 10],'title','','xlabel','')
		set(gcf,'Color','w')
		printmodel('ismipestokesvxfrozen','png','margin','on','marginsize',25,'frame','off','resolution',1.5,'hardcopy','off');
		system(['mv ismipestokesvxfrozen.png ' ISSM_DIR '/website/doc_pdf/validation/Images/ISMIP/TestE ']);
	elseif i==3,
		plotmodel(md,'data',vy,'ylim',[-50 200],'layer',md.numlayers,'sectionvalue','../Exp/ISMIPE.exp','resolution',[10 10],'title','','xlabel','')
		set(gcf,'Color','w')
		printmodel('ismipepattynvxsliding','png','margin','on','marginsize',25,'frame','off','resolution',1.5,'hardcopy','off');
		system(['mv ismipepattynvxsliding.png ' ISSM_DIR '/website/doc_pdf/validation/Images/ISMIP/TestE ']);
	elseif i==4,
		plotmodel(md,'data',vy,'ylim',[-50 200],'layer',md.numlayers,'sectionvalue','../Exp/ISMIPE.exp','resolution',[10 10],'title','','xlabel','')
		set(gcf,'Color','w')
		printmodel('ismipestokesvxsliding','png','margin','on','marginsize',25,'frame','off','resolution',1.5,'hardcopy','off');
		system(['mv ismipestokesvxsliding.png ' ISSM_DIR '/website/doc_pdf/validation/Images/ISMIP/TestE ']);
	end
end
%Fields and tolerances to track changes
field_names     ={ ...
	'VxPattynSliding','VyPattynSliding','VzPattynSliding',...
	'VxStokesSliding','VyStokesSliding','VzStokesSliding',...
	'VxPattynFrozen','VyPattynFrozen','VzPattynFrozen',...
	'VxStokesFrozen','VyStokesFrozen','VzStokesFrozen'
};
field_tolerances={...
	1e-13,1e-13,1e-13,...
	1e-13,1e-13,1e-13,...
	1e-13,1e-13,1e-13,...
	1e-13,1e-13,1e-13,...
};
field_values={};
for i=1:4,
	result=results{i};
	field_values={field_values{:},...
		PatchToVec(result.Vx),...
		PatchToVec(result.Vy),...
		PatchToVec(result.Vz),...
		};
end
