function ISSM_TIER=issmtier()
%ISSMDIR - Get ISSM_TIER environment variable contents.
%
%   Usage:
%      ISSM_TIER=issmtier()

[status,ISSM_TIER]=system('echo $ISSM_TIER');
if status~=0,
	error('issmtier error message: problem when running ''echo $ISSM_TIER'' shell command');
end

if (isempty(ISSM_TIER)) | (length(ISSM_TIER)==1),
	error('issmtier error message: ''ISSM_TIER'' environment variable is empty! You should define ISSM_TIER in your .cshrc or .bashrc!');
end

%get rid of return carriage
ISSM_TIER=strtrim(ISSM_TIER);
