%RUNSTEPS class definition
%
%   Usage:
%      rs = runsteps(varargin)
%
%   Examples:
%      rs = runsteps;                             %build an empty runsteps object
%      rs = runsteps('../Models/');               %build an empty runsteps object with a given repository
%      rs = runsteps('../Models/','models.AGU.'); %build an empty runsteps object with a given repository and a prefix

classdef runsteps
    properties (SetAccess=public) 
		 % {{{1
		 repository='./';
		 prefix    ='model.';
		 steps     =[];
		 %}}}
	 end
	 methods
		 function rs=runsteps(varargin) % {{{1
			 if nargin>2,
				 help runsteps
				 error('runsteps constructor error message: bad usage');
			 end
			 if nargin>1,
				 prefix=varargin{2};
				 if ~ischar(prefix),                            error('prefix is not a string'); end
				 if ~strcmp(regexprep(prefix,'\s+',''),prefix), error('prefix should not have any white space'); end
				 rs.prefix=prefix;
			 end
			 if nargin>0,
				 repository=varargin{1};
				 if ~ischar(repository),        error('repository is not a string'); end
				 if exist(repository,'dir')~=7, error(['Directory ' repository ' not found']), end
				 rs.repository=repository;
			 end
		 end
		 %}}}
		 function disp(rs) % {{{1
			 disp(sprintf('   Repository: ''%s''',rs.repository));
			 disp(sprintf('   Prefix:     ''%s''',rs.prefix));
			 if isempty(rs.steps)
				 disp('   no step');
			 else
				 for i=1:length(rs.steps),
					 disp(sprintf('   step #%i',i));
					 disp(sprintf('      id:      %i',      rs.steps(i).id));
					 disp(sprintf('      string: ''%s''\n',rs.steps(i).string));
				 end
			 end
		 end
		 %}}}
		 function rs = addstep(rs,string),% {{{1

			 %check string
			 if ~ischar(string),                            error('Step provided should be a string'); end
			 if ~strcmp(regexprep(string,'\s+',''),string), error('Step provided should not have any white space'); end

			 rs.steps(end+1).id=length(rs.steps)+1;
			 rs.steps(end).string=string;
		 end% }}}
		 function bool=echo(rs,steps,varargin)% {{{1
			 disp('WARNING: obsolete function. Use PerformStep instead (see issm/projetcs/scripts/runme.m)');
			 if length(steps)==0,
				 error('steps is empty'),
			 elseif (length(steps)==1 & steps==0)
				 if isempty(rs.steps)
					 disp('   no step');
				 else
					 for i=1:length(rs.steps),
						 disp(sprintf('   step #%2i : %s',rs.steps(i).id,rs.steps(i).string));
					 end
				 end
				 bool=true;
				 return;
			 else
				 bool=false;
				 return;
			 end
		 end%}}}
		 function id=GetId(rs,string) % {{{1
			 %GetId - get step id from string
			 %
			 %   Usage:
			 %      GetId(rs,num)

			 for i=1:length(rs.steps),
				 if strcmp(rs.steps(i).string,string),
					 id=i;
					 return;
				 end
			 end
			 error(['No step of flag ' string ' has been found']);

		 end%}}}
		 function md=loadmodel(rs,string),% {{{1

			 %Some checks
			 if ~ischar(string), error('argument provided is not a string'); end

			 %Get model path
			 id=GetId(rs,string);
			 path=[rs.repository '/' rs.prefix rs.steps(id).string];

			 %figure out if the model is there, otherwise, we have to use the default path supplied by user.
			 if ~exist(path,'file'), error(['File ' path ' not found']); end
			 md=loadmodel(path);
		 end%}}}
		 function message(rs,num) % {{{1
			 %MESSAGE - display string of rs with id =num
			 %
			 %   Usage:
			 %      string(rs,num)

			 %Some checks
			 if (abs(floor(num))~=num),
				 error(['runsteps error message: the number provided is not a positive integer']);
			 end
			 if (num>length(rs.steps)),
				 error(['runsteps error message: element with id ' num2str(num) ' not found']);
			 end

			 %Print string
			 disp('WARNING: obsolete function. Use PerformStep instead (see issm/projetcs/scripts/runme.m');
			 disp(sprintf('\n   step #%i -> %s\n',rs.steps(num).id,rs.steps(num).string));
		 end%}}}
		 function bool=PerformStep(rs,steps,num) % {{{1

			 %Some checks
			 if (abs(floor(num))~=num),
				 error(['runsteps error message: the number provided is not a positive integer']);
			 end
			 if (num>length(rs.steps)),
				 error(['runsteps error message: element with id ' num2str(num) ' not found']);
			 end

			 bool=false;

			 %if steps = 0, print all steps in rs and return false
			 if any(steps==0),
				 if num==1,
					 for i=1:length(rs.steps),
						 disp(sprintf('   step #%2i : %s',rs.steps(i).id,rs.steps(i).string));
					 end
				 end
			 end

			 %Ok, now if num is a member of steps, return true
			 if ismember(num,steps),
				 disp(sprintf('\n   step #%i : %s\n',rs.steps(num).id,rs.steps(num).string));
				 bool=true;
			 end
		 end%}}}
		 function savemodel(rs,num,md) % {{{1

			 %check that md is a model
			 if ~isa(md,'model'),       error('savemodel error message: third argument is not a model'); end
			 if (num>length(rs.steps)), error(['runsteps error message: element with id ' num2str(num) ' not found']); end

			 %before saving model, try and find a runme.m file, and save it.
			 A=dbstack;
			 runmefilename=A(2).file;
			 md.runmefile=char(textread(runmefilename,'%s','delimiter','\n'));

			 %save model
			 name=[rs.repository '/' rs.prefix rs.steps(num).string ];
			 save(name,'md','-v7.3');
			 disp(['model saved as: ' name]);
		 end%}}}
	end
end
