function ISSM_DIR=issmdir()
%ISSMDIR - Get ISSM_DIR environment variable contents.
%
%   Usage:
%      ISSM_DIR=issmdir()

[status,ISSM_DIR]=system('echo $ISSM_DIR');
if status~=0,
	error('issmdir error message: problem when running ''echo $ISSM_DIR'' shell command');
end

if (isempty(ISSM_DIR)) | (length(ISSM_DIR)==1),
	error('issmdir error message: ''ISSM_DIR'' environment variable is empty! You should define ISSM_DIR in your .cshrc or .bashrc!');
end

%get rid of return carriage
ISSM_DIR=strtrim(ISSM_DIR);
