function bool=echo(rs,steps,varargin),
%ECHO - display available steps and return true if steps = 0
%
%   Usage:
%      md=echo(rs,steps)
%
%   Examples:
%      md=echo(rs,0)

if length(steps)==0,
	error('steps is empty'),
elseif (length(steps)==1 & steps==0)
	if isempty(rs.steps)
		disp('   no step');
	else
		for i=1:length(rs.steps),
			disp(sprintf('   step #%2i : %s',rs.steps(i).id,rs.steps(i).message));
		end
	end
	bool=true;
	return;
else
	bool=false;
	return;
end
