function [bx by b]=basalstress(md)
%BASALSTRESS - compute basal stress from basal drag and geometric information. 
%
%   Usage:
%      [bx by b]=basalstress(md);
%
%   See also: plot_basaldrag


%compute exponents
s=averaging(md,1./md.drag_p,0);
r=averaging(md,md.drag_p./md.drag_q,0);

%compute horizontal velocity
ub=sqrt(md.vx.^2+md.vy.^2)/md.yts;
ubx=md.vx/md.yts;
uby=md.vy/md.yts;

%compute basal drag
bx=(md.g*(md.rho_ice*md.thickness+md.rho_water*md.bed)).^r.*(md.drag_coefficient).^2.*ubx.^s;
by=(md.g*(md.rho_ice*md.thickness+md.rho_water*md.bed)).^r.*(md.drag_coefficient).^2.*uby.^s;
b=(md.g*(md.rho_ice*md.thickness+md.rho_water*md.bed)).^r.*(md.drag_coefficient).^2.*ub.^s;
