function md=loadresultsfromcluster(md,runtimename)
%LOADRESULTSFROMCLUSTER - load results of solution sequence from cluster
%
%   Usage:
%      md=loadresultsfromcluster(md,runtimename);

%retrieve cluster, to be able to call its methods
cluster=md.cluster;

if nargin==2,
	md.runtimename=runtimename;
end

%Download outputs from the cluster
cluster.Download(md);

%read log files onto  fields
md.errlog=char(textread([md.name '.errlog'],'%s','delimiter','\n'));
md.outlog=char(textread([md.name '.outlog'],'%s','delimiter','\n'));
if ~isempty(md.errlog),
	disp(['loadresultsfromcluster info message: error during solution. Check your errlog and outlog model fields']);
end

%If we are here, no errors in the solution sequence, call loadresultsfromdisk.
md=loadresultsfromdisk(md,[md.name '.outbin']);

%erase the log and output files
if md.qmu_analysis,
	delete([['qmu' num2str(GetPId) '/'] md.name '.outlog']);
	delete([['qmu' num2str(GetPId) '/']  md.name '.errlog']);
else
	delete([md.name '.outlog']);
	delete([md.name '.errlog']);
	delete([md.name '.outbin']);
	delete([md.runtimename '.tar.gz']);
end

%erase input file if run was carried out on same platform.
hostname=oshostname();
if strcmpi(hostname,cluster.name),
	if md.qmu_analysis,
		delete([['qmu' num2str(GetPId) '/'] md.name '.bin']);
		delete([['qmu' num2str(GetPId) '/'] md.name '.queue']);
	else
		delete([md.name '.bin']);
		delete([md.name '.queue']);
		delete([md.name '.petsc']);
	end
end

%post solve phase
md=postsolveparallel(md);
