%COSMOS class definition
%
%   Usage:
%      cluster=cosmos();
%      cluster=cosmos('np',3);
%      cluster=cosmos('np',3,'login','username');

classdef cosmos
    properties (SetAccess=public) 
		 % {{{1
		 name='cosmos'
		 login='larour';
		 np=128;
		 port=0;
		 queue='shortq';
		 time=3*60;
		 codepath='/work00/edw/larour/issm-2.0/bin';
		 executionpath='/work00/edw/larour/Execution';
		 %}}}
	 end
	 methods
		 function cluster=cosmos(varargin) % {{{1
			 options=pairoptions(varargin{:});
			 for i=1:size(options.list,1),
				 fieldname=options.list{i,1};
				 fieldvalue=options.list{i,2};
				 if ismember(fieldname,properties(cosmos)),
					 cluster.(fieldname)=fieldvalue;
				 else
					 disp(['''' fieldname ''' is not a property of cluster cosmos']);
				 end
			 end
		 end
		 %}}}
		 function disp(cluster) % {{{1
			 %  display the object
			 disp(sprintf('class ''%s'' object ''%s'' = ',class(cluster),inputname(1)));
			 disp(sprintf('    name: %s',cluster.name));
			 disp(sprintf('    login: %s',cluster.login));
			 disp(sprintf('    np: %i',cluster.np));
			 disp(sprintf('    port: %i',cluster.port));
			 disp(sprintf('    queue: %s',cluster.queue));
			 disp(sprintf('    time: %i',cluster.time));
			 disp(sprintf('    codepath: %s',cluster.codepath));
			 disp(sprintf('    executionpath: %s',cluster.executionpath));
		 end
		 %}}}
		 function IsConsistent(cluster) % {{{1

			 available_queues={'debug','shortq','longq'};
			 queue_requirements_time=[60*1 60*3 60*17];
			 queue_requirements_np=[32 128 256];

			 QueueRequirements(available_queues,queue_requirements_time,queue_requirements_np,cluster.queue,cluster.np,cluster.time)
		 end
		 %}}}
		 function BuildQueueScript(cluster,modelname,analysis_type,mem_debug) % {{{1

			 %open file for writing: 
			 fid=fopen([modelname '.queue'],'w');

			 fprintf(fid,'#!/bin/bash\n');
			 fprintf(fid,'#PBS -l select=%i:ncpus=1\n',cluster.np);
			 fprintf(fid,'#PBS -N %s\n',modelname);
			 fprintf(fid,'#PBS -l walltime=%i\n',time*60); %walltime is in seconds.
			 fprintf(fid,'#PBS -q %s\n',queue);
			 fprintf(fid,'#PBS -o %s.outlog \n',modelname);
			 fprintf(fid,'#PBS -e %s.errlog \n',modelname);
			 fprintf(fid,'export PBS_O_WORKDIR=%s\n',cluster.executionpath);
			 fprintf(fid,'cd $PBS_O_WORKDIR\n');
			 fprintf(fid,'export OMP_NUM_THREADS=1\n');
			 fprintf(fid,'ulimit -s unlimited\n');
			 fprintf(fid,'ulimit -c 0\n');
			 fprintf(fid,'/opt/mpich/gm/intel10.1/bin/mpirun -np %i %s/issm.exe %s %s %s.bin %s.petsc %s.outbin %s.lock',cluster.np,cluster.codepath,EnumToString(analysis_type),cluster.executionpath,modelname,modelname,modelname,modelname);

			 %close file
			 fclose(fid);

		 end
		 %}}}
		 function LaunchQueueJob(cluster,md,options)%{{{1
			 
			 %lauch command, to be executed via ssh
			 launchcommand=['cd ' cluster.executionpath ' && rm -rf ./' md.runtimename ' && mkdir ' md.runtimename ...
			                ' && cd ' md.runtimename ' && mv ../' md.runtimename '.tar.gz ./ && tar -zxf ' md.runtimename '.tar.gz  && qsub -S/bin/sh ' modelname '.queue '];

			if ~strcmpi(options.batch,'yes'),
				
				%compress the files into one zip.
				compressstring=['tar -zcf ' md.runtimename '.tar.gz ' md.name '.bin ' md.name '.queue '  md.name '.petsc '];
				if md.qmu_analysis,
					compressstring=[compressstring md.name '.qmu.in'];
				end
				system(compressstring);
				
				disp('uploading input file and queueing script');
				issmscpout(md.cluster.name,md.cluster.executionpath,md.cluster.login,md.cluster.port,{[md.runtimename '.tar.gz']});
				
				disp('launching solution sequence on remote cluster');
				issmssh(md.cluster.name,md.cluster.login,md.cluster.port,launchcommand);

			else
				disp('batch mode requested: not launching job interactively');
				disp('launch solution sequence on remote cluster by hand');
			end

		 end
		 %}}}
		 function Download(cluster,md)%{{{1

			%some check
			if isempty(md.runtimename),
				error('pfe Download error message: supply runtime name for results to be loaded!');
			end

			%Figure out the  directory where all the files are in: 
			directory=[executionpath '/' md.runtimename '/'];

			%What packages are we picking up from remote cluster
			packages={[md.name '.outlog'],[md.name '.errlog']};
			if md.qmu_analysis,
				packages{end+1}=[md.name '.qmu.err'];
				packages{end+1}=[md.name '.qmu.out'];
				if isfield(md.qmu_params,'tabular_graphics_data'),
					if md.qmu_params.tabular_graphics_data==true,
						packages{end+1}='dakota_tabular.dat'; 
					end
				end
			else
				packages{end+1}=[md.name '.outbin'];
			end

			%copy files from cluster to present directory
			issmscpin(clustername, login, port, directory, packages);
		end %}}}
	end
end
