%LARSEN class definition
%
%   Usage:
%      cluster=larsen();
%      cluster=larsen('np',3);
%      cluster=larsen('np',3,'login','username');

classdef larsen
    properties (SetAccess=public) 
		 % {{{1
		 name='larsen'
		 login='larour';
		 np=7;
		 port=0;
		 codepath=[issmdir() '/bin'];
		 executionpath=[issmdir() '/../execution'];
		 valgrind=[issmdir() '/externalpackages/valgrind/install/bin/valgrind'];
		 valgrindlib=[issmdir() '/externalpackages/valgrind/install/lib/libmpidebug.so'];
		 valgrindsup=[issmdir() '/externalpackages/valgrind/issm.supp'];
		 %}}}
	 end
	 methods
		 function cluster=larsen(varargin) % {{{1
			 options=pairoptions(varargin{:});
			 for i=1:size(options.list,1),
				 fieldname=options.list{i,1};
				 fieldvalue=options.list{i,2};
				 if ismember(fieldname,properties(larsen)),
					 cluster.(fieldname)=fieldvalue;
				 else
					 disp(['''' fieldname ''' is not a property of cluster larsen']);
				 end
			 end
		 end
		 %}}}
		 function disp(cluster) % {{{1
			 %  display the object
			 disp(sprintf('class ''%s'' object ''%s'' = ',class(cluster),inputname(1)));
			 disp(sprintf('    name: %s',cluster.name));
			 disp(sprintf('    login: %s',cluster.login));
			 disp(sprintf('    np: %i',cluster.np));
			 disp(sprintf('    port: %i',cluster.port));
			 disp(sprintf('    codepath: %s',cluster.codepath));
			 disp(sprintf('    executionpath: %s',cluster.executionpath));
			 disp(sprintf('    valgrind: %s',cluster.valgrind));
			 disp(sprintf('    valgrindlib: %s',cluster.valgrindlib));
			 disp(sprintf('    valgrindsup: %s',cluster.valgrindsup));
		 end
		 %}}}
		 function IsConsistent(cluster) % {{{1
			 if cluster.np>8,
				 error('IsConsistent error message: number of processors should be lest than 16!');
			 end
			 if isnan(cluster.np),
				 error('IsConsistent error message: number of processors should not be NaN!');
			 end
		 end
		 %}}}
		 function BuildQueueScript(cluster,modelname,analysis_type,mem_debug) % {{{1

			 %open file for writing: 
			 fid=fopen([modelname '.queue'],'w');

			 %write instructions for launching a job on the cluster
			 fprintf(fid,'#!/bin/sh\n');
			 if mem_debug==0,
				 fprintf(fid,'mpirun -np %i %s/issm.exe %s %s %s.bin %s.petsc %s.outbin %s.lock  2> %s.errlog >%s.outlog & ',cluster.np,cluster.codepath,EnumToString(analysis_type),cluster.executionpath,modelname,modelname,modelname,modelname,modelname,modelname);
			 else
				 %fprintf(fid,'LD_PRELOAD=%s mpirun -np %i %s --leak-check=full --gen-suppressions=all --suppressions=%s %s/issm.exe %s %s %s.bin %s.petsc %s.outbin %s.lock  2> %s.errlog >%s.outlog & ',cluster.valgrindlib,cluster.np,cluster.valgrind,cluster.valgrindsup,cluster.codepath,EnumToString(analysis_type),cluster.executionpath,modelname,modelname,modelname,modelname,modelname,modelname);
				 fprintf(fid,'LD_PRELOAD=%s mpirun -np %i %s --leak-check=full --suppressions=%s %s/issm.exe %s %s %s.bin %s.petsc %s.outbin %s.lock  2> %s.errlog >%s.outlog & ',cluster.valgrindlib,cluster.np,cluster.valgrind,cluster.valgrindsup, cluster.codepath,EnumToString(analysis_type),cluster.executionpath,modelname,modelname,modelname,modelname,modelname,modelname);
			 end

			 %close file
			 fclose(fid);

		 end
		 %}}}
		 function LaunchQueueJob(cluster,md,options)%{{{1
			 
			 %lauch command, to be executed via ssh
			 launchcommand=['cd ' cluster.executionpath ' && rm -rf ./' md.runtimename ' && mkdir ' md.runtimename ...
			                ' && cd ' md.runtimename ' && mv ../' md.runtimename '.tar.gz ./ && tar -zxf ' md.runtimename '.tar.gz  && source  ' md.name '.queue '];

			if ~strcmpi(options.batch,'yes'),
				
				%compress the files into one zip.
				compressstring=['tar -zcf ' md.runtimename '.tar.gz ' md.name '.bin ' md.name '.queue '  md.name '.petsc '];
				if md.qmu_analysis,
					compressstring=[compressstring md.name '.qmu.in'];
				end
				system(compressstring);
				
				disp('uploading input file and queueing script');
				issmscpout(md.cluster.name,md.cluster.executionpath,md.cluster.login,md.cluster.port,{[md.runtimename '.tar.gz']});
			else
				disp('batch mode requested: not launching job interactively');
				disp('launch solution sequence on remote cluster by hand');
			end

		 end
		 %}}}
	end
end
