function savemodel(rs,num,varargin),
%SAVEMODEL - save model for a given step
%
%   Usage:
%      savemodel(rs,num,md)
%
%   Examples:
%      savemodel(rs,num,md)
%      savemodel(rs,num,'2d',md)

%check inputs
if nargin==3 
	md=varargin{1};
elseif nargin==4
	type=varargin{1};
	md=varargin{2};
else
	help loamodel
	error('savemodel error message: bad usage');
end

%check that md is a model
if ~isa(md,'model'),
	error('savemodel error message: third argument is not a model')
end

%check rs length
if (num>length(rs.steps)),
	error(['runsteps error message: element with id ' num2str(num) ' not found']);
end

%before saving model, try and find a runme.m file, and save it.
if isnans(md.runmefile),
	md.runmefile=cell(0,1);
	md.runmefile{1,1}=char(textread('runme.m','%s','delimiter','\n'));
else
	md.runmefile{end+1,1}=char(textread('runme.m','%s','delimiter','\n'));
end

%save model
if nargin==3,
	name=[rs.repository '/' rs.prefix num2str(num)];
else
	name=[rs.repository '/' rs.prefix num2str(num) '.' type];
end

save(name,'md','-v7.3');
disp(['model saved as: ' name]);
