/*!\file:  PetscOptionsFromAnalysis.cpp
 * \brief: change petsc options using analysis type and parameters
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../objects/objects.h"
#include "../../Container/Parameters.h"
#include "../../toolkits/toolkits.h"

void PetscOptionsFromAnalysis(Parameters* parameters,int analysis_type){

	int     dummy;
	double* analyses=NULL;
	char**  strings=NULL;
	int     numanalyses;
	char*   string=NULL;
	int     found=-1;
	int     i;

	numanalyses=0;
	parameters->FindParam(&strings,&numanalyses,PetscOptionsStringsEnum);

	#ifdef _SERIAL_ //do not take this away, because ISSM loads analyses as a Double Param instead of a DoubleVec Param  when running with only 1 analysis
	if(numanalyses==1){ analyses=(double*)xmalloc(1*sizeof(double)); parameters->FindParam(analyses,PetscOptionsAnalysesEnum);
	}
	else parameters->FindParam(&analyses,&dummy,PetscOptionsAnalysesEnum);
	#else
	parameters->FindParam(&analyses,&dummy,PetscOptionsAnalysesEnum);
	#endif

	if(numanalyses==0)return; //we did not find petsc options, don't bother.

	/*ok, go through analyses and figure out if it corresponds to our analysis_type: */
	found=-1;
	for(i=0;i<numanalyses;i++){
		if (analyses[i]==analysis_type){
			/*found the analysis, get out of here: */
			found=i;
			break;
		}
	}
	if(found==-1){
		/*still haven't found a list of petsc options, go find the default one, for analysis type NoneAnalysisEnum: */
		for(i=0;i<numanalyses;i++){
			if (analyses[i]==NoneAnalysisEnum){
				/*found the default analysis, get out of here: */
				found=i;
				break;
			}
		}
	}
	if (found==-1){
		/*ok, we did not find anything, this is not good! error out: */
		ISSMERROR("%s%s","could find neither a default analysis  nor analysis ",EnumToString(analysis_type));
	}

	/*ok, grab the petsc option string: */
	string=strings[found];

	/*now, reset the options database with this string. Taken from petsc/install/src/sys/objects/pinit.c. This 
	 *capability is not covered by Petsc!: */
	PetscOptionsDestroy();
	PetscOptionsCreate();
	//PetscOptionsCheckInitial_Private();
	//PetscOptionsCheckInitial_Components();
	PetscOptionsSetFromOptions();
	PetscOptionsInsertMultipleString(string); //our patch

	/*Free ressources:{{{1*/
	xfree((void**)&analyses);
	for(i=0;i<numanalyses;i++){
		string=strings[i];
		xfree((void**)&string);
	}
	xfree((void**)&strings);
	/*}}}*/

}
