/*!\file: elements.h
 * \brief prototypes for elements.h
 */ 

#ifndef _SHARED_ELEMENTS_H_
#define  _SHARED_ELEMENTS_H_

#include "../../objects/objects.h"
#include "../../Container/Container.h"
class ElementMatrix;
class ElementVector;

double         Paterson(double temperature);
int            GetVerticesCoordinates(double* xyz,  Node** nodes, int numvertices);
int            GetNumberOfDofs( Node** nodes,int numnodes,int setenum,int approximation_enum);
int*           GetLocalDofList( Node** nodes,int numnodes,int setenum,int approximation_enum);
int*           GetGlobalDofList(Node** nodes,int numnodes,int setenum,int approximation_enum);
ElementMatrix* NewElementMatrix(Node** nodes,int numnodes,Parameters* parameters,int approximation=NoneApproximationEnum);

inline void printarray(double* array,int lines,int cols=1){
	printf("\n");
	for(int i=0;i<lines;i++){  
		printf("   [ ");
		for(int j=0;j<cols;j++) printf(" %12.6g ",array[i*cols+j]);
		printf(" ]\n");
	}  
	printf("\n");
}
inline void printarray(int* array,int lines,int cols=1){
	printf("\n");
	for(int i=0;i<lines;i++){  
		printf("   [ ");
		for(int j=0;j<cols;j++) printf(" %6i",array[i*cols+j]);
		printf(" ]\n");
	}  
	printf("\n");
}

#endif //ifndef _SHARED_ELEMENTS_H_
