%PFE class definition
%
%   Usage:
%          cluster=pfe();
%
classdef pfe
    properties (SetAccess=public)  
		 % {{{1
		 name='pfe'
		 login='elarour';
		 numnodes=20;
		 cpuspernode=8; 
		 port=1025;
		 queue='long';
		 time=12*60;
		 processor='neh';
		 codepath='/staff/elarour/trunk/bin';
		 executionpath='/nobackupp10/elarour/Testing';
	 end
	 properties (SetAccess=private) 
		 np=20*8;
		 % }}}
	 end
	 methods
		 function cluster=pfe(varargin) % {{{1
			 options=pairoptions(varargin{:});
			 for i=1:size(options.list,1),
				 fieldname=options.list{i,1};
				 fieldvalue=options.list{i,2};
				 if ismember(fieldname,properties(pfe)),
					 cluster.(fieldname)=fieldvalue;
				 else
					 disp(['''' fieldname ''' is not a property of cluster pfe']);
				 end
			 end
		 end
		 %}}}
		 function disp(cluster) % {{{1
			 %  display the object
			 disp(sprintf('class ''%s'' object ''%s'' = ',class(cluster),inputname(1)));
			 disp(sprintf('    name: %s',cluster.name));
			 disp(sprintf('    login: %s',cluster.login));
			 disp(sprintf('    port: %i',cluster.port));
			 disp(sprintf('    numnodes: %i',cluster.numnodes));
			 disp(sprintf('    cpuspernode: %i',cluster.cpuspernode));
			 disp(sprintf('    np: %i',cluster.cpuspernode*cluster.numnodes));
			 disp(sprintf('    queue: %s',cluster.queue));
			 disp(sprintf('    time: %i',cluster.time));
			 disp(sprintf('    processor: %s',cluster.processor));
			 disp(sprintf('    codepath: %s',cluster.codepath));
			 disp(sprintf('    executionpath: %s',cluster.executionpath));
		 end
		 %}}}
		 function IsConsistent(cluster) % {{{1

			 available_queues={'long'};
			 queue_requirements_time=[7200];
			 queue_requirements_np=[2048];

			 QueueRequirements(available_queues,queue_requirements_time,queue_requirements_np,cluster.queue,cluster.np,cluster.time)

			 %now, check cluster.cpuspernode according to processor type
			 if (strcmpi(cluster.processor,'har') | strcmpi(cluster.processor,'neh')),
				 if ((cluster.cpuspernode>8 ) | (cluster.cpuspernode<1)),
					 error('IsConsistent error message: cpuspernode should be between 1 and 8 for ''neh'' and ''har'' processors');
				 end
			 elseif strcmpi(cluster.processor,'wes'),
				 if ((cluster.cpuspernode>12 ) | (cluster.cpuspernode<1)),
					 error('IsConsistent error message: cpuspernode should be between 1 and 12 for ''wes'' processors');
				 end
			 else
				 error('IsConsistent error message: unknown processor type, should be ''neh'',''wes'' or ''har''');
			 end

		 end
		 %}}}
		 function BuildQueueScript(cluster,modelname,analysis_type,mem_debug) % {{{1

			 %compute number of processors
			 cluster.np=cluster.numnodes*cluster.cpuspernode;

			 %open file for writing: 
			 fid=fopen([modelname '.queue'],'w');

			 fprintf(fid,'#PBS -S /bin/bash\n');
			 fprintf(fid,'#PBS -N %s\n',modelname);
			 fprintf(fid,'#PBS -l select=%i:ncpus=%i:model=%s\n',cluster.numnodes,cluster.cpuspernode,cluster.processor);
			 fprintf(fid,'#PBS -l walltime=%i\n',cluster.time*60); %walltime is in seconds.
			 fprintf(fid,'#PBS -W group_list=s1010\n');
			 fprintf(fid,'#PBS -m e\n');
			 fprintf(fid,'#PBS -o %s.outlog \n',modelname);
			 fprintf(fid,'#PBS -e %s.errlog \n\n',modelname);

			 fprintf(fid,'. /usr/share/modules/init/bash\n\n');

			 fprintf(fid,'module load comp-intel/11.1.046\n');
			 fprintf(fid,'module load mpi/mpt.1.25\n');
			 fprintf(fid,'module load math/intel_mkl_64_10.0.011\n\n');

			 fprintf(fid,'export PATH="$PATH:."\n\n');
			 fprintf(fid,'export MPI_GROUP_MAX=64\n\n');

			 fprintf(fid,'cd $PBS_O_WORKDIR\n\n');

			 fprintf(fid,'mpiexec -verbose -np %i %s/issm.exe %s $PBS_O_WORKDIR %s.bin %s.petsc %s.outbin %s.lock',cluster.np,cluster.codepath,EnumToString(analysis_type),modelname,modelname,modelname,modelname);

			 %close file
			 fclose(fid);

		 end
		 %}}}
		 function command=LaunchCommand(cluster,modelruntimename,modelname)% {{{1
			 command=['cd ' cluster.executionpath ' && rm -rf ./' modelruntimename ' && mkdir ' modelruntimename ' && cd ' modelruntimename ' && mv ../' modelruntimename '.tar.gz ./ && tar -zxf ' modelruntimename '.tar.gz  && qsub ' modelname '.queue '];
		 end
		 %}}}
	end
end
