%POLLUX class definition
%
%   Usage:
%          cluster=pollux();
%
classdef pollux
    properties (SetAccess=public) 
		 % {{{1
		 name='pollux'
		 login='larour';
		 np=128;
		 port=0;
		 queue='shortp';
		 time=180;
		 codepath='/workc/edw/larour/issm-2.0/bin'
		 executionpath='/workc/edw/larour/Testing/Execution'
		 %}}}
	 end
	 methods
		 function cluster=pollux(varargin) % {{{1
			 options=pairoptions(varargin{:});
			 for i=1:size(options.list,1),
				 fieldname=options.list{i,1};
				 fieldvalue=options.list{i,2};
				 if ismember(fieldname,properties(pollux)),
					 cluster.(fieldname)=fieldvalue;
				 else
					 disp(['''' fieldname ''' is not a property of cluster pollux']);
				 end
			 end
		 end
		 %}}}
		 function disp(cluster) % {{{1
			 %  display the object
			 disp(sprintf('class ''%s'' object ''%s'' = ',class(cluster),inputname(1)));
			 disp(sprintf('    name: %s',cluster.name));
			 disp(sprintf('    login: %s',cluster.login));
			 disp(sprintf('    port: %i',cluster.port));
			 disp(sprintf('    np: %i',cluster.np));
			 disp(sprintf('    queue: %s',cluster.queue));
			 disp(sprintf('    time: %i',cluster.time));
			 disp(sprintf('    codepath: %s',cluster.codepath));
			 disp(sprintf('    executionpath: %s',cluster.executionpath));
		 end
		 %}}}
		 function IsConsistent(cluster) % {{{1

			 available_queues={'shortp','longp'};
			 queue_requirements_time=[180 720];
			 queue_requirements_np=[128 128];

			 QueueRequirements(available_queues,queue_requirements_time,queue_requirements_np,cluster.queue,cluster.np,cluster.time)
		 end
		 %}}}
		 function BuildQueueScript(cluster,modelname,analysis_type,mem_debug) % {{{1

			 %open file for writing: 
			 fid=fopen([modelname '.queue'],'w');

			 fprintf(fid,'#!/bin/sh\n');
			 fprintf(fid,'#PBS -l walltime=%i\n',cluster.time*60); %walltime is in seconds.
			 fprintf(fid,'#PBS -N %s\n',modelname);
			 fprintf(fid,'#PBS -l ncpus=%i\n',cluster.np);
			 if ~isempty(queue),
				 fprintf(fid,'#PBS -q %s\n',cluster.queue);
			 end
			 fprintf(fid,'#PBS -o %s.outlog \n',modelname);
			 fprintf(fid,'#PBS -e %s.errlog \n',modelname);

			 fprintf(fid,'export PBS_O_WORKDIR=%s\n',cluster.executionpath);
			 fprintf(fid,'cd $PBS_O_WORKDIR\n');
			 fprintf(fid,'export OMP_NUM_THREADS=1\n');
			 fprintf(fid,'dplace -s1 -c0-%i mpirun -np %i %s/issm.exe %s %s %s.bin %s.petsc %s.outbin %s.lock',cluster.np-1,cluster.np,cluster.codepath,EnumToString(analysis_type),cluster.executionpath,modelname,modelname,modelname,modelname);

			 %close file
			 fclose(fid);

		 end
		 %}}}
		 function command=LaunchCommand(cluster,modelruntimename,modelname)% {{{1
			 command=['cd ' cluster.executionpath ' && rm -rf ./' modelruntimename ' && mkdir ' modelruntimename ' && cd ' modelruntimename ' && mv ../' modelruntimename '.tar.gz ./ && tar -zxf ' modelruntimename '.tar.gz  && qsub ' modelname '.queue '];
		 end
		 %}}}
	end
end
