function md=parameterize(md,parametername)
%PARAMETERIZE - parameterize a model
%
%   from a parameter matlab file, start filling in all the @model fields that were not 
%   filled in by the mesh.m and geography.m @model methods.
%   Warning: the paramter file must be able to be run in Matlab
%
%   Usage:
%      md=parameterize(md,parametername)
%
%   Example:
%      md=parameterize(md,'Square.par');

%some checks
if md.counter>=4,
	%We need to take this out, as it gets too constraining. 
	choice=input('This model already has parameters and has been extruded. Are you sure you want to go ahead? (y/n)','s');
	if ~strcmp(choice,'y')
		error('no parameters done ... exiting');
	end
elseif md.counter==3
	disp('This model already has parameters, overwriting...')
else
	if (md.counter<2)
		error('parameterize error message: you need to run geography.m first on this model');
	else
		md.counter=3;
	end
end
if ~exist(parametername),
	error(['parameterize error message: file ' parametername ' not found !']);
end

%Try and run parameter file.
temporaryname=['TemporaryParameterFile' num2str(GetPId()) ];
copyfile(parametername,[temporaryname '.m']);

%WARNING: this is a bug of matlab: the TemporaryParameterFile must be cleared
%otherwise matlab keeps the previous version of this file which is not what
%we want!!!
eval(['clear ' temporaryname]);

try,
	eval(temporaryname);
	delete([temporaryname '.m']);
catch me,
	delete([temporaryname '.m']);

	%copy error message
	me2=struct('message',me.message,'stack',me.stack);

	%rename parameter file
	for i=1:length(me2.stack)-1,
		if (strncmp(fliplr(me2.stack(i).file),fliplr([temporaryname '.m']),length(temporaryname)+2))
			me2.stack(i).file=parametername;
		end
		if strcmp(me2.stack(i).name,temporaryname),
			me2.stack(i).name=parametername;
		end
		if strcmp(me2.stack(i).name,temporaryname),
			%remove parameterize.m error "TemporaryParameterFile" misleading
			me2.stack(i)=[];
		end
	end

	%throw error message
	rethrow(me2);
end

%Keep track of parameter file
md.parameterfile=char(textread(parametername,'%s','delimiter','\n'));

%Name and notes
if isempty(md.name), 
	[a,root,c,d]=fileparts(parametername);
	md.name=root; 
end
md=addnote(md,['Model created by using parameter file: ' parametername ' on: ' datestr(now)]);
