md=mesh(model,'../Exp/Square.exp',150000);
md=geography(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=setelementstype(md,'macayeal','all');
md=SetParallel(md,3);
md=solve(md,'analysis_type',DiagnosticSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vel','Pressure'};
field_tolerances={1e-13,1e-13,1e-13,1e-13};
field_values={...
	PatchToVec(md.results.DiagnosticSolution.Vx),...
	PatchToVec(md.results.DiagnosticSolution.Vy),...
	PatchToVec(md.results.DiagnosticSolution.Vel),...
	PatchToVec(md.results.DiagnosticSolution.Pressure),...
	};
