md=mesh(model,'../Exp/Square.exp',200000);
md=geography(md,'../Exp/SquareShelf.exp','');
md=parameterize(md,'../Par/SquareSheetShelf.par');
md=setelementstype(md,'macayeal','all');
md=SetParallel(md,3);

%partitioning
md.npart=10;
md=partitioner(md,'package','chaco','npart',md.npart);
md.part=md.part-1;
md.qmu_analysis=1;

%Dakota options
%variables
md.variables.rho_ice=normal_uncertain('RhoIce',md.rho_ice,0.01);

%responses
md.responses.MaxVel=response_function('scaled_Thickness',[],[0.0001 0.001 0.01 0.25 0.5 0.75 0.99 0.999 0.9999]);

%method
md.qmu_method     =dakota_method('nond_l');

%parameters
md.qmu_params.direct=true;
md.qmu_params.analysis_driver='diagnostic';
md.qmu_params.evaluation_concurrency=1;
md.qmu_params.interval_type='forward';


%imperative! 
md.eps_rel=10^-5; %tighten for qmu analysese

%solve
md=solve(md,'analysis_type',DiagnosticSolutionEnum,'overwrite','y');
md=tres(md,'dakota');

%test on thickness
h=zeros(md.npart,1);
for i=1:md.npart,
	h(i)=md.dakotaresults.dresp_out(i).mean;
end

%project onto grid
thickness=h(md.part+1);

%Fields and tolerances to track changes
field_names     ={'Thickness'};
field_tolerances={1e-10};
field_values={thickness};
