md=mesh(model,'../Exp/Square.exp',180000);
md=geography(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=extrude(md,3,1);
md=setelementstype(md,'macayeal','all');
md=SetParallel(md,3);
md=solve(md,'analysis_type',Transient3DSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx1','Vy1','Vz1','Vel1','Pressure1','Bed1','Surface1','Thickness1','Temperature1','MeltingRate1', ...
				      'Vx2','Vy2','Vz2','Vel2','Pressure2','Bed2','Surface2','Thickness2','Temperature2','MeltingRate2', ...
					   'Vx3','Vy3','Vz3','Vel3','Pressure3','Bed3','Surface3','Thickness3','Temperature3','MeltingRate3'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13};
field_values={...
	PatchToVec(md.results.Transient3DSolution(1).Vx),...
	PatchToVec(md.results.Transient3DSolution(1).Vy),...
	PatchToVec(md.results.Transient3DSolution(1).Vz),...
	PatchToVec(md.results.Transient3DSolution(1).Vel),...
	PatchToVec(md.results.Transient3DSolution(1).Pressure),...
	PatchToVec(md.results.Transient3DSolution(1).Bed),...
	PatchToVec(md.results.Transient3DSolution(1).Surface),...
	PatchToVec(md.results.Transient3DSolution(1).Thickness),...
	PatchToVec(md.results.Transient3DSolution(1).Temperature),...
	PatchToVec(md.results.Transient3DSolution(1).MeltingRate),...
	PatchToVec(md.results.Transient3DSolution(2).Vx),...
	PatchToVec(md.results.Transient3DSolution(2).Vy),...
	PatchToVec(md.results.Transient3DSolution(2).Vz),...
	PatchToVec(md.results.Transient3DSolution(2).Vel),...
	PatchToVec(md.results.Transient3DSolution(2).Pressure),...
	PatchToVec(md.results.Transient3DSolution(2).Bed),...
	PatchToVec(md.results.Transient3DSolution(2).Surface),...
	PatchToVec(md.results.Transient3DSolution(2).Thickness),...
	PatchToVec(md.results.Transient3DSolution(2).Temperature),...
	PatchToVec(md.results.Transient3DSolution(2).MeltingRate),...
	PatchToVec(md.results.Transient3DSolution(3).Vx),...
	PatchToVec(md.results.Transient3DSolution(3).Vy),...
	PatchToVec(md.results.Transient3DSolution(3).Vz),...
	PatchToVec(md.results.Transient3DSolution(3).Vel),...
	PatchToVec(md.results.Transient3DSolution(3).Pressure),...
	PatchToVec(md.results.Transient3DSolution(3).Bed),...
	PatchToVec(md.results.Transient3DSolution(3).Surface),...
	PatchToVec(md.results.Transient3DSolution(3).Thickness),...
	PatchToVec(md.results.Transient3DSolution(3).Temperature),...
	PatchToVec(md.results.Transient3DSolution(3).MeltingRate),...
	};
