md=mesh(model,'../Exp/Square.exp',150000);
md=meshconvert(md);
md=geography(md,'all','');
md=parameterize(md,'../Par/SquareShelfConstrained.par');
md.prognostic_DG=1;
md.vy=md.vy+400;
md=setelementstype(md,'macayeal','all');
md=SetParallel(md,3);
md=solve(md,'analysis_type',BalancedthicknessSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Thickness'};
field_tolerances={1e-13};
field_values={...
	PatchToVec(md.results.BalancedthicknessSolution.Thickness),...
	};
