function md=loadresultsfromcluster(md,runtimename)
%LOADRESULTSFROMCLUSTER - load results of solution sequence from cluster
%
%   Usage:
%      md=loadresultsfromcluster(md,runtimename);

%Figure out parameters for this particular cluster
codepath=md.cluster.codepath;
executionpath=md.cluster.executionpath;
login=md.cluster.login;
port=md.cluster.port;
clustername=md.cluster.name;

if nargin==2,
	md.runtimename=runtimename;
end

if isempty(md.runtimename),
	error('supply runtime name for results to be loaded!');
end

%Figure out the  directory where all the files are in: 
directory=[executionpath '/' md.runtimename '/'];

%What packages are we picking up from remote cluster
packages={[md.name '.outlog'],[md.name '.errlog']};
if md.qmu_analysis,
	packages{end+1}=[md.name '.qmu.err'];
	packages{end+1}=[md.name '.qmu.out'];
	if isfield(md.qmu_params,'tabular_graphics_data'),
		if md.qmu_params.tabular_graphics_data==true,
			packages{end+1}='dakota_tabular.dat'; 
		end
	end
else
	packages{end+1}=[md.name '.outbin'];
end

%copy files from cluster to present directory
issmscpin(clustername, login, port, directory, packages);

%read log files onto  fields
md.errlog=char(textread([md.name '.errlog'],'%s','delimiter','\n'));
md.outlog=char(textread([md.name '.outlog'],'%s','delimiter','\n'));
if ~isempty(md.errlog),
	disp(['loadresultsfromcluster info message: error during solution. Check your errlog and outlog model fields']);
end

%If we are here, no errors in the solution sequence, call loadresultsfromdisk.
md=loadresultsfromdisk(md,[md.name '.outbin']);

%erase the log and output files
if md.qmu_analysis,
	delete([['qmu' num2str(GetPId) '/'] md.name '.outlog']);
	delete([['qmu' num2str(GetPId) '/']  md.name '.errlog']);
else
	delete([md.name '.outlog']);
	delete([md.name '.errlog']);
	delete([md.name '.outbin']);
	delete([md.runtimename '.tar.gz']);
end

%erase input file if run was carried out on same platform.
hostname=oshostname();
if strcmpi(hostname,clustername),
	if md.qmu_analysis,
		delete([['qmu' num2str(GetPId) '/'] md.name '.bin']);
		delete([['qmu' num2str(GetPId) '/'] md.name '.queue']);
	else
		delete([md.name '.bin']);
		delete([md.name '.queue']);
		delete([md.name '.petsc']);
	end
end

%post solve phase
md=postsolveparallel(md);
