md=mesh(model,'../Exp/Square.exp',180000);
md=geography(md,'all','');
md=parameterize(md,'../Par/SquareShelfConstrained.par');
md=extrude(md,3,1);
md=setelementstype(md,'macayeal','all');
md.cluster=none;
md=solve(md,'analysis_type',ThermalSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Temperature','MeltingRate'};
field_tolerances={1e-13,1e-13};
field_values={...
	PatchToVec(md.results.ThermalSolution.Temperature),...
	PatchToVec(md.results.ThermalSolution.MeltingRate),...
	};
