md=mesh(model,'../Exp/Square.exp',180000);
md=geography(md,'','');
md=parameterize(md,'../Par/SquareSheetConstrained.par');
md=extrude(md,4,1);
md=setelementstype(md,'hutter','all');
md.cluster=none;
md.dt=0;
md=solve(md,'analysis_type',SteadystateSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vz','Vel','Pressure','Temperature','MeltingRate'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13
};
field_values={...
	PatchToVec(md.results.SteadystateSolution.Vx),...
	PatchToVec(md.results.SteadystateSolution.Vy),...
	PatchToVec(md.results.SteadystateSolution.Vz),...
	PatchToVec(md.results.SteadystateSolution.Vel),...
	PatchToVec(md.results.SteadystateSolution.Pressure),...
	PatchToVec(md.results.SteadystateSolution.Temperature),...
	PatchToVec(md.results.SteadystateSolution.MeltingRate),...
	};
