%ASTRID class definition
%
%   Usage:
%          cluster=astrid();
%
classdef astrid
    properties (SetAccess=public) 
	%{{{1
		name='astrid'
        np   =15; %number of processors
		codepath=[issmdir '/bin'];
		executionpath=[issmdir '../execution'];
		valgrind=[issmdir '/externalpackages/valgrind/install/bin/valgrind'];
		valgrindlib=[issmdir '/externalpackages/valgrind/install/lib/libmpidebug.so'];
		valgrindsup=[issmdir 'externalpackages/valgrind/issm.supp'];
		login='larour';
		port=0;
	%}}}
    end
    methods
		function []=disp(md) %{{{1
		%  display the object
		disp(sprintf('class ''%s'' object ''%s'' = ',class(md),inputname(1)));
		disp(sprintf('    name: %s',md.name));
		disp(sprintf('    np: %i',md.np));
		disp(sprintf('    codepath: %s',md.codepath));
		disp(sprintf('    executionpath: %s',md.executionpath));
		disp(sprintf('    valgrind: %s',md.valgrind));
		disp(sprintf('    valgrindlib: %s',md.valgrindlib));
		disp(sprintf('    valgrindsup: %s',md.valgrindsup));
		end
		%}}}
		function IsConsistent(md) %{{{1
			if md.np>16,
				error('IsConsistent error message: number of processors should be lest than 16!');
			end
			if isnan(md.np),
				error('IsConsistent error message: number of processors should not be NaN!');
			end
		end
		%}}}
		function BuildQueueScript(md,modelname,analysis_type,mem_debug) %{{{1
		
		%open file for writing: 
		fid=fopen([modelname '.queue'],'w');

		%write instructions for launching a job on the cluster
		fprintf(fid,'#!/bin/sh\n');
		if mem_debug==0,
			fprintf(fid,'mpirun -np %i %s/issm.exe %s %s %s.bin %s.outbin %s.lock  2> %s.errlog >%s.outlog & ',md.np,md.codepath,EnumToString(analysis_type),md.executionpath,modelname,modelname,modelname,modelname,modelname);
		else
			%fprintf(fid,'LD_PRELOAD=%s mpirun -np %i %s --leak-check=full --gen-suppressions=all --suppressions=%s %s/issm.exe %s %s %s.bin %s.outbin %s.lock  2> %s.errlog >%s.outlog & ',md.valgrindlib,md.np,md.valgrind,md.valgrindsup,md.codepath,EnumToString(analysis_type),md.executionpath,modelname,modelname,modelname,modelname,modelname);
			fprintf(fid,'LD_PRELOAD=%s mpirun -np %i %s --leak-check=full --suppressions=%s %s/issm.exe %s %s %s.bin %s.outbin %s.lock  2> %s.errlog >%s.outlog & ',md.valgrindlib,md.np,md.valgrind,md.valgrindsup, md.codepath,EnumToString(analysis_type),md.executionpath,modelname,modelname,modelname,modelname,modelname);
		end

		%close file
		fclose(fid);

		end
		%}}}
		function command=LaunchCommand(md,modelruntimename,modelname)%{{{1
		command=['cd ' md.executionpath ' && rm -rf ./' modelruntimename ' && mkdir ' modelruntimename ' && cd ' modelruntimename ' && mv ../' modelruntimename '.tar.gz ./ && tar -zxf ' modelruntimename '.tar.gz  && source  ' modelname '.queue '];
		end
		%}}}
	end
end
