%PFE class definition
%
%   Usage:
%          cluster=pfe();
%
classdef pfe
    properties (SetAccess=public)  
		%{{{1
		name='pfe'
		numnodes=20;
        cpuspernode=8; 
		queue='long';
		time=12*60;
		processor='neh';
		codepath='/staff/elarour/trunk/bin';
		executionpath='/nobackupp10/elarour/Testing';
		login='elarour';
		port=1025;
	end
    properties (SetAccess=private) 
		np=20*8;
		%}}}
    end
    methods
		function []=disp(md) %{{{1
		%  display the object
		disp(sprintf('class ''%s'' object ''%s'' = ',class(md),inputname(1)));
		disp(sprintf('    name: %s',md.name));
		disp(sprintf('    numnodes: %i',md.numnodes));
		disp(sprintf('    cpuspernode: %i',md.cpuspernode));
		disp(sprintf('    np: %i',md.cpuspernode*md.numnodes));
		disp(sprintf('    queue: %s',md.queue));
		disp(sprintf('    time: %i',md.time));
		disp(sprintf('    processor: %s',md.processor));
		disp(sprintf('    codepath: %s',md.codepath));
		disp(sprintf('    executionpath: %s',md.executionpath));
		end
		%}}}
		function IsConsistent(md) %{{{1

			available_queues={'long'};
			queue_requirements_time=[7200];
			queue_requirements_np=[2048];

			QueueRequirements(available_queues,queue_requirements_time,queue_requirements_np,md.queue,md.np,md.time)

			%now, check md.cpuspernode according to processor type
			if (strcmpi(md.processor,'har') | strcmpi(md.processor,'neh')),
				if ((md.cpuspernode>8 ) | (md.cpuspernode<1)),
					error('IsConsistent error message: cpuspernode should be between 1 and 8 for ''neh'' and ''har'' processors');
				end
			else if strcmpi(md.processor,'wes'),
				if ((md.cpuspernode>12 ) | (md.cpuspernode<1)),
					error('IsConsistent error message: cpuspernode should be between 1 and 12 for ''wes'' processors');
				end
			else
				error('IsConsistent error message: unknown processor type, should be ''neh'',''wes'' or ''har'');
			end

		end
		%}}}
		function BuildQueueScript(md,modelname,analysis_type,mem_debug) %{{{1
md.np=md.numnodes*md.cpuspernode;
			
			%open file for writing: 
			fid=fopen([modelname '.queue'],'w');

			fprintf(fid,'#PBS -S /bin/bash\n');
			fprintf(fid,'#PBS -N %s\n',modelname);
			fprintf(fid,'#PBS -l select=%i:ncpus=%i:model=%s\n',md.numnodes,md.cpuspernode,md.processor);
			fprintf(fid,'#PBS -l walltime=%i\n',md.time*60); %walltime is in seconds.
			fprintf(fid,'#PBS -W group_list=s1010\n');
			fprintf(fid,'#PBS -m e\n');
			fprintf(fid,'#PBS -o %s.outlog \n',modelname);
			fprintf(fid,'#PBS -e %s.errlog \n\n',modelname);

			fprintf(fid,'. /usr/share/modules/init/bash\n\n');

			fprintf(fid,'module load comp-intel/11.1.046\n');
			fprintf(fid,'module load mpi/mpt.1.25\n');
			fprintf(fid,'module load math/intel_mkl_64_10.0.011\n\n');

			fprintf(fid,'export PATH="$PATH:."\n\n');
			fprintf(fid,'export MPI_GROUP_MAX=64\n\n');

			fprintf(fid,'cd $PBS_O_WORKDIR\n\n');

			fprintf(fid,'mpiexec -verbose -np %i %s/issm.exe %s $PBS_O_WORKDIR %s.bin %s.outbin %s.lock',md.np,md.codepath,EnumToString(analysis_type),modelname,modelname,modelname);

			%close file
			fclose(fid);

		end
		%}}}
		function command=LaunchCommand(md,modelruntimename,modelname)%{{{1
			command=['cd ' md.executionpath ' && rm -rf ./' modelruntimename ' && mkdir ' modelruntimename ' && cd ' modelruntimename ' && mv ../' modelruntimename '.tar.gz ./ && tar -zxf ' modelruntimename '.tar.gz  && qsub ' modelname '.queue '];
		end
		%}}}
	end
end
