%COSMOS class definition
%
%   Usage:
%          cluster=cosmos();
%
classdef cosmos
    properties (SetAccess=public) 
	%{{{1
		name='cosmos'
        np   =128; %number of processors
		queue='shortq';
		time=3*60;
		codepath='/work00/edw/larour/issm-2.0/bin';
        executionpath='/work00/edw/larour/Execution';
		login='larour';
		port=0;
	%}}}
    end
    methods
		function []=disp(md) %{{{1
		%  display the object
		disp(sprintf('class ''%s'' object ''%s'' = ',class(md),inputname(1)));
		disp(sprintf('    name: %s',md.name));
		disp(sprintf('    np: %i',md.np));
		disp(sprintf('    queue: %s',md.queue));
		disp(sprintf('    time: %i',md.time));
		disp(sprintf('    codepath: %s',md.codepath));
		disp(sprintf('    executionpath: %s',md.executionpath));
		end
		%}}}
		function IsConsistent(md) %{{{1

		available_queues={'debug','shortq','longq'};
		queue_requirements_time=[60*1 60*3 60*17];
		queue_requirements_np=[32 128 256];

		QueueRequirements(available_queues,queue_requirements_time,queue_requirements_np,md.queue,md.np,md.time)
		end
		%}}}
		function BuildQueueScript(md,modelname,analysis_type,mem_debug) %{{{1
		
		%open file for writing: 
		fid=fopen([modelname '.queue'],'w');

		fprintf(fid,'#!/bin/bash\n');
		fprintf(fid,'#PBS -l select=%i:ncpus=1\n',md.np);
		fprintf(fid,'#PBS -N %s\n',modelname);
		fprintf(fid,'#PBS -l walltime=%i\n',time*60); %walltime is in seconds.
		fprintf(fid,'#PBS -q %s\n',queue);
		fprintf(fid,'#PBS -o %s.outlog \n',modelname);
		fprintf(fid,'#PBS -e %s.errlog \n',modelname);
		fprintf(fid,'export PBS_O_WORKDIR=%s\n',md.executionpath);
		fprintf(fid,'cd $PBS_O_WORKDIR\n');
		fprintf(fid,'export OMP_NUM_THREADS=1\n');
		fprintf(fid,'ulimit -s unlimited\n');
		fprintf(fid,'ulimit -c 0\n');
		fprintf(fid,'/opt/mpich/gm/intel10.1/bin/mpirun -np %i %s/issm.exe %s %s %s.bin %s.outbin %s.lock',md.np,md.codepath,EnumToString(analysis_type),md.executionpath,modelname,modelname,modelname);

		%close file
		fclose(fid);

		end
		%}}}
		function command=LaunchCommand(md,modelruntimename,modelname)%{{{1
		command=['cd ' md.executionpath ' && rm -rf ./' modelruntimename ' && mkdir ' modelruntimename ' && cd ' modelruntimename ' && mv ../' modelruntimename '.tar.gz ./ && tar -zxf ' modelruntimename '.tar.gz  && qsub -S/bin/sh ' modelname '.queue '];
		end
		%}}}
	end
end
