md=mesh(model,'../Exp/Square.exp',100000);
md=geography(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=extrude(md,2,1);
md=setelementstype(md,'stokes','~Pattyn.exp','fill','pattyn');
md.spcvelocity(:,4:6)=0;
md.verbose=10;
md.vx=zeros(md.numberofgrids,1);
md.vy=zeros(md.numberofgrids,1);
md.vz=zeros(md.numberofgrids,1);
md.cluster='none';
md=solve(md,'analysis_type',DiagnosticSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vz','Vel','Pressure'};
field_tolerances={1e-09,1e-09,1e-09,1e-09,1e-09};
field_values={...
	PatchToVec(md.results.DiagnosticSolution.Vx),...
	PatchToVec(md.results.DiagnosticSolution.Vy),...
	PatchToVec(md.results.DiagnosticSolution.Vz),...
	PatchToVec(md.results.DiagnosticSolution.Vel),...
	PatchToVec(md.results.DiagnosticSolution.Pressure),...
	};
