/*!\file:  NewElementVector.cpp
 * \brief create new element matrix
 */ 
#include "./elements.h"

ElementVector* NewElementVector(Node** nodes,int numnodes,Parameters* parameters,int approximation){

	/*parameters: */
	bool kff=false;

	/*output: */
	ElementVector* pe=NULL;
	int gsize;
	int fsize;
	int* gglobaldoflist=NULL;
	int* flocaldoflist=NULL;
	int* fglobaldoflist=NULL;

	/*retrieve some parameters: */
	parameters->FindParam(&kff,KffEnum);

	/*get number of dofs in sets g,f and s: */
	gsize=GetNumberOfDofs(nodes,numnodes,GsetEnum,approximation);
	if(kff)fsize=GetNumberOfDofs(nodes,numnodes,FsetEnum,approximation);

	/*get dof lists for f and s set: */
	if(!kff){
		gglobaldoflist=GetGlobalDofList(nodes,numnodes,GsetEnum,approximation);
	}
	else{
		flocaldoflist= GetLocalDofList( nodes,numnodes,FsetEnum,approximation);
		fglobaldoflist=GetGlobalDofList(nodes,numnodes,FsetEnum,approximation);
	}

	/*constructor for ElementVector: */
	if(!kff)pe=new ElementVector(gsize,gglobaldoflist);
	else    pe=new ElementVector(gsize,flocaldoflist,fglobaldoflist,fsize);

	/*Clean-up and return*/
	xfree((void**)&gglobaldoflist);
	xfree((void**)&flocaldoflist);
	xfree((void**)&fglobaldoflist);
	return pe;
}
