/*!\file:  NewElementMatrix.cpp
 * \brief create new element matrix
 */ 
#include "./elements.h"

ElementMatrix* NewElementMatrix(Node** nodes,int numnodes,Parameters* parameters,int approximation){

	/*parameters: */
	bool kff=false;

	/*output: */
	ElementMatrix* Ke=NULL;
	int gsize;
	int fsize;
	int ssize;
	int* gglobaldoflist=NULL;
	int* flocaldoflist=NULL;
	int* fglobaldoflist=NULL;
	int* slocaldoflist=NULL;
	int* sglobaldoflist=NULL;
	bool square=true;

	/*retrieve some parameters: */
	parameters->FindParam(&kff,KffEnum);

	/*get number of dofs in sets g,f and s: */
	gsize=GetNumberOfDofs(nodes,numnodes,GsetEnum,approximation);
	if(kff){
		fsize=GetNumberOfDofs(nodes,numnodes,FsetEnum,approximation);
		ssize=GetNumberOfDofs(nodes,numnodes,SsetEnum,approximation);
	}

	/*get dof lists for f and s set: */
	gglobaldoflist=GetGlobalDofList(nodes,numnodes,GsetEnum,approximation);
	if(kff){
		flocaldoflist= GetLocalDofList( nodes,numnodes,FsetEnum,approximation);
		fglobaldoflist=GetGlobalDofList(nodes,numnodes,FsetEnum,approximation);
		slocaldoflist= GetLocalDofList( nodes,numnodes,SsetEnum,approximation);
		sglobaldoflist=GetGlobalDofList(nodes,numnodes,SsetEnum,approximation);
	}

	/*constructor for ElementMatrix: */
	if(!kff) Ke=new ElementMatrix(square,gglobaldoflist,gsize);
	else     Ke=new ElementMatrix(square,gglobaldoflist,gsize,flocaldoflist,fglobaldoflist,fsize,slocaldoflist,sglobaldoflist,ssize);

	/*Clean-up and return*/
	xfree((void**)&gglobaldoflist);
	xfree((void**)&flocaldoflist);
	xfree((void**)&sglobaldoflist);
	xfree((void**)&slocaldoflist);
	xfree((void**)&fglobaldoflist);
	return Ke;
}
