/*!\file:  GetGlobalDofList.cpp
 * \brief create new element matrix
 */ 
#include "./elements.h"

int* GetGlobalDofList(Node** nodes,int numnodes,int setenum,int approximation){

	int  i,numdof,count;
	int  ndof_list[numnodes];
	int *doflist = NULL;

	/*First, figure out size of doflist: */
	numdof=0;
	for(i=0;i<numnodes;i++){
		ndof_list[i]=nodes[i]->GetNumberOfDofs(approximation,setenum);
		numdof+=ndof_list[i];
	}

	if(numdof){
		/*Allocate: */
		doflist=(int*)xmalloc(numdof*sizeof(int));

		/*Populate: */
		count=0;
		for(i=0;i<numnodes;i++){
			nodes[i]->GetDofList(&doflist[count],approximation,setenum);
			count+=ndof_list[i];
		}
	}
	else doflist=NULL;

	return doflist;
}
