/*!\file: elements.h
 * \brief prototypes for elements.h
 */ 

#ifndef _SHARED_ELEMENTS_H_
#define  _SHARED_ELEMENTS_H_

#include "../../objects/objects.h"
#include "../../Container/Container.h"

double Paterson(double temperature);
int    GetVerticesCoordinates(double* xyz,  Node** nodes, int numvertices);

inline void printarray(double* array,int lines,int cols=1){
	printf("\n");
	for(int i=0;i<lines;i++){  
		printf("   [ ");
		for(int j=0;j<cols;j++) printf(" %12.6g ",array[i*cols+j]);
		printf(" ]\n");
	}  
	printf("\n");
}
inline void printarray(int* array,int lines,int cols=1){
	printf("\n");
	for(int i=0;i<lines;i++){  
		printf("   [ ");
		for(int j=0;j<cols;j++) printf(" %6i",array[i*cols+j]);
		printf(" ]\n");
	}  
	printf("\n");
}

#endif //ifndef _SHARED_ELEMENTS_H_
