function md=presolve(md)
%PRESOLVE - pre-solve phase operations.
%
%   Usage:
%      md=presolve(md)

%deal with outputfilename and inputfilename
md.inputfilename=[md.name '.bin'];
md.outputfilename=[md.name '.outbin'];

%deal with rifts.
if isempty(md.rifts) | isnans(md.rifts),
	md.numrifts=0;
else
	md.numrifts=numel(md.rifts);
end

numpairs=0;
for i=1:md.numrifts,
	numpairs=numpairs+size(md.rifts(i).penaltypairs,1);
end

md.riftinfo=zeros(numpairs,10); % 2 for grids + 2 for elements+ 2 for  normals + 1 for length + 1 for fill + 1 for friction + 1 for fraction.

count=1;
for i=1:md.numrifts,
	numpairsforthisrift=size(md.rifts(i).penaltypairs,1);
	md.riftinfo(count:count+numpairsforthisrift-1,1:7)=md.rifts(i).penaltypairs;
	md.riftinfo(count:count+numpairsforthisrift-1,8)=md.rifts(i).fill;
	md.riftinfo(count:count+numpairsforthisrift-1,9)=md.rifts(i).friction;
	md.riftinfo(count:count+numpairsforthisrift-1,10)=md.rifts(i).fraction;
	md.riftinfo(count:count+numpairsforthisrift-1,11)=md.rifts(i).fractionincrement;
	count=count+numpairsforthisrift;
end

%deal with petsc options
md.petscrc=PetscOptions2PetscRc(md.petscoptions,'petsc.rc');
