md=mesh(model,'../Exp/Square.exp',180000);
md=geography(md,'all','');
md=parameterize(md,'../Par/SquareShelfConstrained.par');
md=extrude(md,3,2);
md=setelementstype(md,'macayeal','all');
md.cluster=oshostname;
md.verbose=1;
md=solve(md,'analysis_type',DiagnosticSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vz','Vel','Pressure'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13};
field_values={...
	PatchToVec(md.results.DiagnosticSolution.Vx),...
	PatchToVec(md.results.DiagnosticSolution.Vy),...
	PatchToVec(md.results.DiagnosticSolution.Vz),...
	PatchToVec(md.results.DiagnosticSolution.Vel),...
	PatchToVec(md.results.DiagnosticSolution.Pressure),...
	};
