function petscstring=PetscOptions2PetscRc(petscoptions,filename)
%PETSCOPTIONS2PETSCRC: build a Petsc compatible options file, from the petscoptions model field  + return options string
%
% Usage:     petscstring=PetscOptions2PetscRc(petscoptions,filename);
%
% Example:   md.petscsrc=PetscOptions2PetscRc(md.petscoptions,'petsc.rc');
%
% See also: solversettomumps, solversettoasm, etc ...


%open file for writing
fid=fopen(filename,'w');
if fid==-1,
	error(['PetscOptions2PetscRc error: could not open ' filename ' for writing']);
end

%write header
fprintf(fid,'%s%s%s\n\n','%Petsc options file: ',filename,' written from Matlab petscoptions array');

%initialize petscstring: 
petscstring='';

%start writing options
for i=1:length(petscoptions),
	option=petscoptions{i};
	if isempty(option),
		%do nothing
	elseif length(option)==1,
		%this option has only one argument
		fprintf(fid,'-%s\n',option{1});
		petscstring=[petscstring ' -' option{1}];
	elseif length(option)==2,
		%option with value. value can be string or scalar
		if isscalar(option{2}),
			fprintf(fid,'-%s %g\n',option{1},option{2});
			petscstring=[petscstring ' -' option{1} ' ' num2str(option{2})];
		elseif ischar(option{2}),
			fprintf(fid,'-%s %s\n',option{1},option{2});
			petscstring=[petscstring ' -' option{1} ' ' option{2}];
		else
			error(['PetscOptions2PetscRc error: option #' num2str(i) ' is not well formatted']);
		end
	else 
		error(['PetscOptions2PetscRc error: option #' num2str(i) ' is not well formatted']);
	end

end
