function md=LaunchQueueJob(md,executionpath,login,port,options)
%LAUNCHQUEUEJOB- Launch queue script for cluster
%
%   Usage:
%      md=LaunchQueueJob(md,executionpath,launchcommand,login,port,options)


%first, check we have the binary file and the queueing script
if ~exist([ md.name '.bin'],'file'),
	error('LaunchQueueJobcosmos error message: Binary input file missing, cannot go forward');
end

if ~exist([ md.name '.queue'],'file'),
	error('LaunchQueueJobcosmos error message: queueing script missing, cannot go forward');
end

if md.qmu_analysis & ~exist([ md.name '.qmu.in'],'file'),
	error('LaunchQueueJobcosmos error message: missing dakota input file, cannot go forward');
end

if ~strcmpi(options.batch,'yes'),
	
	%compress the files into one zip.
	compressstring=['tar -zcf ' md.runtimename '.tar.gz ' md.name '.bin ' md.name '.queue '];
	if md.qmu_analysis,
		compressstring=[compressstring md.name '.qmu.in'];
	end
	system(compressstring);
	
	disp('uploading input file and queueing script');
	issmscpout(md.cluster,executionpath,login,port,{[md.runtimename '.tar.gz']});

	disp('launching solution sequence on remote cluster');
	issmssh(md.cluster,login,port,ClusterLaunchCommand(md.cluster,md.runtimename,md.name,executionpath));

else
	disp('batch mode requested: not launching job interactively');
	disp('launch solution sequence on remote cluster by hand');
end
