function md=plug(md,field,value)
%PLUG - plugs the holes of a model field
%
%   This routine takes a model field interpolated on a mesh, and plugs the holes (made of value)
%   to the nearest interpolation
%
%   Usage:
%      md=plug(md,field,value)

%First retrieve field
fieldvalues=eval(['md.' field]);

if isnan(value),
	holevalues=find(isnan(fieldvalues));
elseif isinf(value),
	holevalues=find(isinf(fieldvalues));
else
	holevalues=find(fieldvalues==value);
end

for i=1:length(holevalues),

	index=holevalues(i);

	if ~mod(i,100),
		%disp(['Step ' num2str(i) '/' num2str(length(holevalues))]);
	end

	distance=sqrt( (md.x(index)-md.x).^2 + (md.y(index)-md.y).^2 );
	distance(holevalues)=10^10; %be sure we are not picking up the nan grids!

	index2=find(distance==min(distance));index2=index2(1);

	fieldvalues(index)=fieldvalues(index2);
end

%Set fieldvalues in md.field
eval(['md.' field '=fieldvalues;']);
