function  undoplot(n)
%UNDOPLOT - undo plot
%
%   o n>0 removes the last n figure items added
%   o n<0 removes all the figures done after figure=-n
%   undoplot to remove only the last figure
%
%   Usage:
%      undoplot(n)

%some checks on n
if nargin==0
	n=1;
end
if ischar(n)
	n = sscanf(n,'%i');
end

%how many plots have been done?
g=get(gca,'children');
L=length(g);


if n>0
	%erase plot
	for i=1:min(n,L)
		delete(g(i));
	end
end

if n<0
	%erase plot
	for i=1:min(L-n,L)
		delete(g(i));
	end
end
