function plot_sarpwr(md,options,width,i);
%PLOT_SARPWR - plot radar image
%
%   Usage:
%      plot_sarpwr(md,options,width,i);
%
%   See also: PLOTMODEL

%plot mesh sarpwr
subplot(width,width,i); 

%units
if exist(options,'unit'),
	unit=getfieldvalue(options,'unit');
	md.x=md.x*unit;
	md.y=md.y*unit;
	md.z=md.z*unit;
end
					
imagesc(md.sarxm,md.sarym,double(md.sarpwr)),set(gca,'YDir','normal');colormap(gray);

%apply options
options=addfielddefault(options,'colorbar',0);
options=changefieldvalue(options,'colormap','gray');

applyoptions(md,[],options);
