function plot_mesh(md,options,nlines,ncols,i);
%PLOT_MESH - plot model mesh
%
%   Usage:
%      plot_mesh(md,options,nlines,ncols,i);
%
%   See also: PLOTMODEL

%process data and model
[x y z elements is2d]=processmesh(md,[],options);

%plot mesh
subplot(nlines,ncols,i); 

%plot mesh
if is2d
	A=elements(:,1); B=elements(:,2); C=elements(:,3); 
	patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
else
	A=elements(:,1); B=elements(:,2); C=elements(:,3); D=elements(:,4); E=elements(:,5); F=elements(:,6);
	patch( 'Faces', [A B C],  'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [D E F],  'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [A B E D],'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [B E F C],'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [C A D F],'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
end

%apply options
options=addfielddefault(options,'title','Mesh');
options=addfielddefault(options,'colorbar',0);
applyoptions(md,[],options);
