function md_list=modelsextractfromdomains(md,directory)
%modelsextractfromdomains- extract several self contained models according to a list of domains
%
%   Usage:
%      md_list=modelsextractfromdomains(md,'Basins/');
%
%   Examples:
%      md_list=modelsextract(md,'Basins/');
%
%   See also: MODELSEXTRACTS, MODELEXTRACT



%go into directory and get list of files.
cd(directory);
basins=listfiles;
cd ..

models=cell(0,1);
for i=1:length(basins),
	models{end+1,1}=modelextract(md,[directory '/' basins{i}]);
end

%return model list: 
md_list=modellist(models);

end %end of this function
