function displaycontrol(md)
%DISPLAYCONTROL - display control parameters
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays control parameters from model md, 
%   only if requested.
%
%   Usage:
%      displaycontrol(md)

disp(sprintf('   Control solution parameters:\n'));
if md.control_analysis,
	fielddisplay(md,'control_type','parameter where inverse control is carried out; ex: DragCoefficientEnum, or RheologyBbarEnum)');
	fielddisplay(md,'weights','weights applied to the misfit of each node');
	fielddisplay(md,'nsteps','number of optimization searches');
	fielddisplay(md,'eps_cm','misfit convergence criterion. Default is 1%, NaN if not applied');
	fielddisplay(md,'optscal','scaling factor on gradient direction during optimization, for each optimization step');
	fielddisplay(md,'cm_responses','indicate the type of response for each optimization steps: SurfaceAbsVelMisfitEnum, SurfaceRelVelMisfitEnum, SurfaceLogVelMisfitEnum, SurfaceLogVxVyMisfitEnum, SurfaceAverageVelMisfitEnum or ThicknessAbsMisfitEnum');
	fielddisplay(md,'maxiter','maximum iterations during each optimization step');
	fielddisplay(md,'tolx','minimum tolerance which will stop one optimization search');
	fielddisplay(md,'cm_jump','decrease threshold for misfit, default is 30%');
	fielddisplay(md,'cm_noisedmp','noise dampening coefficient, 0 if not applied');
	fielddisplay(md,'cm_min','absolute minimum acceptable value of the inversed parameter');
	fielddisplay(md,'cm_max','absolute maximum acceptable value of the inversed parameter');
	fielddisplay(md,'cm_gradient','stop control method solution at gradient');
	fielddisplay(md,'meanvel','velocity scaling factor when evaluating relative or logarithmic misfit');
	fielddisplay(md,'epsvel','for relative fit, avoids misfit becoming infinity, for logarithmic fit, threshold for velocity');
	fielddisplay(md,'plot','visualization of the results of each iteration yes -> 1 no -> 0. Default is 1');
else
	disp(sprintf('         %s','no scheduled control. activate by doing md.control_analysis=1'));
end
