function plot_section(md,data,options,nlines,ncols,i)
%PLOT_SECTION - plot a given field on a section
%
%   Usage:
%      plot_section(md,options,width,i);
%
%   See also: PLOTMODEL

%How many subplots?
if exist(options,'showsection')

	%Compute the indexes of the 2 plots (one for the sectionvalue and one for showsection
	upperplots=fix((i-1)/width);
	if upperplots==0, leftplots=i-1; else leftplots=i-width*upperplots-1; end
	index1=4*width*upperplots+2*leftplots+1;
	index2=index1+1;
	width=2*width;
else
	index1=i;
end

%process model
[x_m y_m z_m elements_m is2d]=processmesh(md,[],options);

%Get number of curves and generate random colors
numcurves=size(data,2);
colorm=getfieldvalue(options,'colormap','jet');
options=changefieldvalue(options,'colormap','jet');
eval(['color=' colorm '(numcurves);']);

%Loop over number of curves
for i=1:numcurves,

	[datai datatype]=processdata(md,data(:,i),options);

	%replug x and y onto model so that SectionValue treats the problem correctly
	if exist(options,'layer')
		md.x=md.x2d; md.y=md.y2d; md.elements=md.elements2d; md.dim=2;
	end

	%resolution
	if exist(options,'resolution'),
		resolution=getfieldvalue(options,'resolution');
	else %Default resolution
		resolution=[1000 10*md.numlayers];
		disp(['plot_section warning: no resolution specified, use default resolution: [horizontal_resolution vertical_resolution]=[' num2str(resolution)  ']']);
	end

	%Compute section value
	[elements,x,y,z,s,data_s]=SectionValues(md,datai,getfieldvalue(options,'sectionvalue'),resolution);

	%units
	if exist(options,'unit'),
		unit=getfieldvalue(options,'unit');
		x=x*unit;
		y=y*unit;
		z=z*unit;
		s=s*unit;
	end

	%2D
	if is2d

		%Show Section if requested by user
		if exist(options,'showsection')

			%compute number of labels
			numlabels=min(getfieldvalue(options,'showsection'),length(s));
			shift=fix(length(s)/numlabels);

			%plot labels on current graph
			hold on
			text(s(1),data_s(1),'1','backgroundcolor',[0.8 0.9 0.8])
			for i=2:numlabels-1
				text(s(1+(i-1)*shift),data_s(1+(i-1)*shift),num2str(i),'backgroundcolor',[0.8 0.9 0.8])
			end
			text(s(end),data_s(end),'end','backgroundcolor',[0.8 0.9 0.8])

			%plot section only with labels
			subplot(width,width,index2)
			plot_unit(x_m,y_m,z_m,elements_m,data(:,i),is2d,datatype,options)
			hold on
			text(x(1),y(1),'1','backgroundcolor',[0.8 0.9 0.8])
			for i=2:numlabels-1
				text(x(1+(i-1)*shift),y(1+(i-1)*shift),num2str(i),'backgroundcolor',[0.8 0.9 0.8])
			end
			text(x(end),y(end),'end','backgroundcolor',[0.8 0.9 0.8])
			plot(x,y,'-r')
			axis([min(md.x)-1 max(md.x)+1 min(md.y)-1 max(md.y)+1])
			view(2)
		end

		%plot section value
		hold on;
		subplot(nlines,ncols,index1)
		%subplot(1,3,[2 3])
		if i==1,
			plot(s,data_s,'-.','color',color(i+1,:),'LineWidth',getfieldvalue(options,'linewidth',1))
		elseif i==2
			plot(s,data_s,'-.','color',color(i+1,:),'LineWidth',getfieldvalue(options,'linewidth',1))
		elseif i==3
			plot(s,data_s,'--','color',color(i+1,:),'LineWidth',getfieldvalue(options,'linewidth',1))
		elseif i==4
			plot(s,data_s,'-','color',color(i+1,:),'LineWidth',getfieldvalue(options,'linewidth',1))
		elseif i==5
			plot(s,data_s,'-','color','k','LineWidth',getfieldvalue(options,'linewidth',1))
		end

		%3D
	else
		%plot section value
		%if user requested view2: 2d plot with curvilinear coordinate
		if (getfieldvalue(options,'view',3)==2 )

			%Show Section if requested by user
			if exist(options,'showsection')

				%compute number of labels
				numlabels=min(getfieldvalue(options,'showsection'),length(s));
				shift=fix(length(s)/numlabels);

				%plot labels on current graph
				hold on
				text(s(1),z(1),'1','backgroundcolor',[0.8 0.9 0.8])
				for i=2:numlabels-1
					text(s(1+(i-1)*shift),z(1+(i-1)*shift),num2str(i),'backgroundcolor',[0.8 0.9 0.8])
				end
				text(s(end),z(end),'end','backgroundcolor',[0.8 0.9 0.8])

				%plot section only with labels
				subplot(width,width,index2)
				plot_unit(x_m,y_m,z_m,elements_m,data(:,i),is2d,datatype,options)
				hold on
				text(x(1),y(1),'1','backgroundcolor',[0.8 0.9 0.8])
				for i=2:numlabels-1
					text(x(1+(i-1)*shift),y(1+(i-1)*shift),num2str(i),'backgroundcolor',[0.8 0.9 0.8])
				end
				text(x(end),y(end),'end','backgroundcolor',[0.8 0.9 0.8])
				plot(x,y,'-r')
				axis([min(md.x)-1 max(md.x)+1 min(md.y)-1 max(md.y)+1])
				view(2)
			end

			subplot(width,width,index1)
			A=elements(:,1); B=elements(:,2); C=elements(:,3);  D=elements(:,4); 
			patch( 'Faces', [A B C D], 'Vertices', [s z zeros(length(s),1)],'FaceVertexCData',data_s,'FaceColor','interp','EdgeColor','none');

		else

			%Show Section if requested by user
			if exist(options,'showsection')

				%compute number of labels
				numlabels=min(getfieldvalue(options,'showsection'),length(s));
				shift=fix(length(x)/numlabels);

				%plot labels on current graph
				hold on
				text(x(1),y(1),z(1),'1','backgroundcolor',[0.8 0.9 0.8])
				for i=2:numlabels-1
					text(x(1+(i-1)*shift),y(1+(i-1)*shift),z(1+(i-1)*shift),num2str(i),'backgroundcolor',[0.8 0.9 0.8])
				end
				text(x(end),y(end),z(end),'end','backgroundcolor',[0.8 0.9 0.8])

				%plot section only with labels
				subplot(width,width,index2)
				plot_unit(x_m,y_m,z_m,elements_m,data,is2d,datatype,options)
				hold on
				text(x(1),y(1),'1','backgroundcolor',[0.8 0.9 0.8])
				for i=2:numlabels-1
					text(x(1+(i-1)*shift),y(1+(i-1)*shift),num2str(i),'backgroundcolor',[0.8 0.9 0.8])
				end
				text(x(end),y(end),'end','backgroundcolor',[0.8 0.9 0.8])
				plot(x,y,'-r')
				axis([min(md.x)-1 max(md.x)+1 min(md.y)-1 max(md.y)+1])
				view(2)
			end

			subplot(width,width,index1)
			A=elements(:,1); B=elements(:,2); C=elements(:,3);  D=elements(:,4); 
			patch( 'Faces', [A B C D], 'Vertices', [x y z],'FaceVertexCData',data_s,'FaceColor','interp','EdgeColor','none');
			view(3)

		end
	end
end

%apply options
options=addfielddefault(options,'title','Section value');
if (md.dim==2)
	options=addfielddefault(options,'colorbar',0);
end
if ((md.dim==2) | getfieldvalue(options,'view')==2 )
	options=addfielddefault(options,'xlabel','Curvilinear coordinate');
	options=addfielddefault(options,'axis','auto');
end
if (md.dim==3 & getfieldvalue(options,'view')==2 )
	options=addfielddefault(options,'ylabel','z');
end
applyoptions(md,[],options);
