/*\file VelocityDepthAverage.c
 *\brief: average velocity through thickness
 */

#include "./VelocityDepthAverage.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	Vec      ug=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&VelocityDepthAverageUsage);

	/*Input datasets: */
	FetchData((void**)&elements,NULL,NULL,ELEMENTS,"DataSet",NULL);
	FetchData((void**)&nodes,NULL,NULL,NODES,"DataSet",NULL);
	FetchData((void**)&loads,NULL,NULL,LOADS,"DataSet",NULL);
	FetchData((void**)&materials,NULL,NULL,MATERIALS,"DataSet",NULL);
	FetchData((void**)&ug,NULL,NULL,UG,"Vector",NULL);

	/*!Call core code: */
	VelocityDepthAveragex(ug,elements,nodes,loads,materials);

	/*write output : */
	WriteData(UGOUT,ug,0,0,"Vector",NULL);
	/*Free ressources: */
	delete elements;
	delete nodes;
	delete loads;
	delete materials;
	VecFree(&ug);
	
	/*end module: */
	MODULEEND();

}

void VelocityDepthAverageUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [ug] = %s(elements, nodes,loads, materials, ug);\n",__FUNCT__);
	_printf_("\n");
}
