/*\file ThicknessExtrude.c
 *\brief: extrude thickness vertically
 */

#include "./ThicknessExtrude.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	Vec      tg=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ThicknessExtrudeUsage);

	/*Input datasets: */
	FetchData((void**)&elements,NULL,NULL,ELEMENTS,"DataSet",NULL);
	FetchData((void**)&nodes,NULL,NULL,NODES,"DataSet",NULL);
	FetchData((void**)&loads,NULL,NULL,LOADS,"DataSet",NULL);
	FetchData((void**)&materials,NULL,NULL,MATERIALS,"DataSet",NULL);
	FetchData((void**)&tg,NULL,NULL,TG,"Vector",NULL);

	/*!Call core code: */
	ThicknessExtrudex(tg,elements,nodes,loads,materials);

	/*write output : */
	WriteData(TGOUT,tg,0,0,"Vector",NULL);
	/*Free ressources: */
	delete elements;
	delete nodes;
	delete loads;
	delete materials;
	VecFree(&tg);
	
	/*end module: */
	MODULEEND();

}

void ThicknessExtrudeUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [tg] = %s(elements, nodes,loads, materials, tg);\n",__FUNCT__);
	_printf_("\n");
}
