/*!\file:  qmu.cpp
 * \brief: run qmu capabilities using Dakota library
 */ 

#ifdef HAVE_CONFIG_H
#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#undef __FUNCT__ 
#define __FUNCT__ "qmu"

#include "ParallelLibrary.H"
#include "ProblemDescDB.H"
#include "DakotaStrategy.H"
#include "DakotaModel.H"
#include "DakotaInterface.H"

#include "../objects/DakotaPlugin.h"
#include "../shared/shared.h"
#include "../include/macros.h"
#include "parallel.h"

void qmu(const char* dakota_input_file,FemModel* femmodels,ParameterInputs* inputs,int analysis_type,int sub_analysis_type){

	extern int my_rank;
	int status=0;
	Dakota::ModelLIter ml_iter;

	if(my_rank==0){

		// Instantiate/initialize the parallel library and problem description
		// database objects.
		Dakota::ParallelLibrary parallel_lib("serial");
		Dakota::ProblemDescDB problem_db(parallel_lib);

		// Manage input file parsing, output redirection, and restart processing
		// without a CommandLineHandler.  This version relies on parsing of an
		// input file.
		problem_db.manage_inputs(dakota_input_file);
		// specify_outputs_restart() is only necessary if specifying non-defaults
		//parallel_lib.specify_outputs_restart(NULL, NULL, NULL, NULL);

		// Instantiate the Strategy object (which instantiates all Model and
		// Iterator objects) using the parsed information in problem_db.
		Dakota::Strategy selected_strategy(problem_db);

		// convenience function for iterating over models and performing any
		// interface plug-ins
		Dakota::ModelList& models = problem_db.model_list();

		for (ml_iter = models.begin(); ml_iter != models.end(); ml_iter++) {

			Dakota::Interface& interface = ml_iter->interface();

			//set DB nodes to the existing Model specification
			problem_db.set_db_model_nodes(ml_iter->model_id());

			// Serial case: plug in derived Interface object without an analysisComm
			interface.assign_rep(new SIM::DakotaPlugin(problem_db,femmodels,inputs,analysis_type,sub_analysis_type), false);
		}
	
		// Execute the strategy
		problem_db.lock(); // prevent run-time DB queries
		selected_strategy.run_strategy();
		
		//Warn other cpus that we are done running the dakota iterator
		MPI_Bcast(&status,1,MPI_INT,0,MPI_COMM_WORLD); 

	}
	else{

		for(;;){

			SpawnCore(NULL,NULL,NULL,0,femmodels,inputs,analysis_type,sub_analysis_type);

			//Figure out if cpu 0 is done iterating
			MPI_Bcast(&status,1,MPI_INT,0,MPI_COMM_WORLD); 

			//yes!
			if(status){
				break; //yes, we are done
			}
			else{
				/*We are not done: */


			}
		}

			
	}
}
