
/*
	OutputPrognostic.c: output model results for prognostic solution.
*/
#undef __FUNCT__ 
#define __FUNCT__ "OutputPrognostic"

#include "../toolkits/toolkits.h"
#include "../shared/shared.h"
#include "../io/io.h"
#include "../objects/objects.h"
	
void OutputPrognostic(Vec h_g,FemModel* femmodel,char* filename){

	int i;
	extern int my_rank;
	
	/* output: */
	FILE* fid=NULL;

	NodeSets* nodesets=NULL;
	Vec       partition=NULL;
	char*     analysis_type="prognostic";
	
	/* standard output: */
	Vec partition_shifted=NULL;
	double* serial_partition=NULL;
	
	double* serial_hg=NULL;
	int     h_g_size;
	int     one=1;
	int     nods;

	/*Recover prognostic horiz femmodel: */
	partition=femmodel->partition;
	
	/*serialize outputs: */
	VecDuplicate(partition,&partition_shifted);
	VecCopy(partition,partition_shifted);
	VecShift(partition_shifted,1.0); //matlab indexing starts at 1

	VecToMPISerial(&serial_partition,partition_shifted);
	VecGetSize(partition,&nods);

	VecToMPISerial(&serial_hg,h_g);
	VecGetSize(h_g,&h_g_size);
	
	/* Open output file to write raw binary data: */
	if(my_rank==0){
		fid=pfopen(filename,"wb");

		/*Write solution type: */
		WriteDataToDisk(analysis_type,NULL,NULL,"String",fid);

		/*Write partition: */
		WriteDataToDisk(serial_partition,&nods,&one,"Mat",fid);
		
		/*Write solution to disk: */
		WriteDataToDisk(serial_hg,&h_g_size,&one,"Mat",fid);

		/*Close file: */
		pfclose(fid,filename);
	}

	/*Free ressources: */
	VecFree(&partition_shifted);
	xfree((void**)&serial_partition);
	xfree((void**)&serial_hg);
}	
