/*!\file Param.h
 * \brief: header file for param object
 */

#ifndef _PARAM_H_
#define _PARAM_H_

#include "./Object.h"
#include "../toolkits/toolkits.h"

#define PARAMSTRING 200 //max string length

enum param_type { STRING, STRINGARRAY, INTEGER, DOUBLE, DOUBLEVEC, DOUBLEMAT, PETSCVEC, PETSCMAT };

class Param: public Object{

	private: 
		int	id; /*! id, to track it*/
		char name[PARAMSTRING]; /*! name of parameter*/
		int  type; /*! param type, from enum above*/
		
		int  integer;
		double ddouble;
		char  string[PARAMSTRING];
		char** stringarray;
		double* doublevec;
		double* doublemat;
		Vec vec;
		Mat mat;
		int M; //dimensions of vectors and matrices
		int N;

	public:

		Param();
		Param(int param_id, char* param_name, int param_type);
		~Param();

		void  Echo();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		char* GetParameterName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		
		void  SetDouble(double value);
		void  SetDoubleVec(double* value,int size);
		void  SetVec(Vec value);
		void  SetInteger(int value);
		void  SetString(char* value);
		void  SetStringArray(char** value,int size);
		void  GetParameterValue(void* pvalue);
		
		int   GetId(); 
		int   MyRank();
		void  DistributeNumDofs(int* numdofspernode,int analysis_type);
		int   GetType();
		int   GetM();
		int   GetN();
		Object* copy();

};

#endif  /* _PARAM_H_ */
