/*!\file:  DakotaPlugin.cpp (see DakotaPlugin.h for explanations)
 */ 

#include "DakotaResponse.H"
#include "ParamResponsePair.H"
#include "DakotaPlugin.h"
#include "system_defs.h"
#include "ProblemDescDB.H"
#include "ParallelLibrary.H"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../objects/objects.h"
#include "../parallel/parallel.h"

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <string>


namespace SIM {

//constructor
DakotaPlugin::DakotaPlugin(const Dakota::ProblemDescDB& problem_db,FemModel* in_femmodels, ParameterInputs* in_inputs, int in_analysis_type, int in_sub_analysis_type):Dakota::DirectApplicInterface(problem_db){

	femmodels=in_femmodels;
	inputs=in_inputs;
	analysis_type=in_analysis_type;
	sub_analysis_type=in_sub_analysis_type;
}

//destructor
DakotaPlugin::~DakotaPlugin(){ /* Virtual destructor handles referenceCount at Interface level. */ }

int DakotaPlugin::derived_map_ac(const Dakota::String& driver) {

	int status=0;
	int i;
	double* variables=NULL;
	char** variable_descriptors=NULL;
	char*  variable_descriptor=NULL;
	double* responses=NULL;

	/*Before launching analysis, we need to transfer the dakota inputs into Issm 
	 *readable variables: */

	/*First, the variables: */
	variables=(double*)xmalloc(numACV*sizeof(double));
	for(i=0;i<numACV;i++){
		variables[i]=xC[i];
	}
	/*The descriptors: */
	variable_descriptors=(char**)xmalloc(numACV*sizeof(char*));
	for(i=0;i<numACV;i++){
		string label=xCLabels[i];
		variable_descriptor=(char*)xmalloc((strlen(label.c_str())+1)*sizeof(char));
		strcpy(variable_descriptor,label.c_str());
		
		variable_descriptors[i]=variable_descriptor;
	}

	/*Initialize responses: */
	responses=(double*)xcalloc(numFns,sizeof(double));

	/*run core solution: */
	SpawnCore(responses,variables,variable_descriptors,numACV,femmodels,inputs,analysis_type,sub_analysis_type);

	/*populate responses: */
	for(i=0;i<numFns;i++){
		fnVals[i]=responses[i];
	}

	/*warn other cpus that we are done running this iteration: */
	MPI_Bcast(&status,1,MPI_INT,0,MPI_COMM_WORLD); 

	/*Free ressources:*/
	xfree((void**)&variables);
	for(i=0;i<numACV;i++){
		variable_descriptor=variable_descriptors[i];
		xfree((void**)&variable_descriptor);
	}
	xfree((void**)&variable_descriptors);
	xfree((void**)&responses);

	return 0;
}

} // namespace SIM
