/*!\file VelocityDepthAveragex
 * \brief: average velocity through thickness
 */

#include "./VelocityDepthAveragex.h"

#undef __FUNCT__ 
#define __FUNCT__ "VelocityDepthAveragex"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void VelocityDepthAveragex( Vec ug, DataSet* elements,DataSet* nodes, DataSet* loads, DataSet* materials){

	double* ug_serial=NULL;

	/*First, get elements and nodes configured: */
	elements->Configure(elements,loads, nodes, materials);
	nodes->Configure(elements,loads, nodes, materials);

	/*Serialize velcoity: */
	VecToMPISerial(&ug_serial,ug);

	/*Depth average velocity, onto base of mesh: */
	elements->VelocityDepthAverageAtBase(ug,ug_serial);

	/*Assemble vector: */
	VecAssemblyBegin(ug);
	VecAssemblyEnd(ug);

	/*ok, ug is now correct at the base. We need to extrude the value of the base 
	 * through thickness :*/

	/*Serialize velcoity: */
	xfree((void**)&ug_serial);
	VecToMPISerial(&ug_serial,ug);

	/*Extrude velocity, regardless of collapsed elements: */
	elements->VelocityExtrudeAllElements(ug,ug_serial);

	/*Assemble vector: */
	VecAssemblyBegin(ug);
	VecAssemblyEnd(ug);

	/*Free ressources:*/
	xfree((void**)&ug_serial);

}
